﻿using System.Collections.Generic;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongImpl : SongPhraseListImpl, ISong
    {
        private readonly int ppq;
        private readonly Tempo tempo;
        private readonly List<ISongTrack> tracks;

        public SongImpl(int pqq, Tempo tempo)
        {
            this.ppq = ppq;
            this.tempo = tempo;
            tracks = new List<ISongTrack>();
        }

        public ISongMeasure getSongScoreMeasure(int measure)
        {
            return getScoreMeasure(measure - 1);
        }

        public int Resolution
        {
            get { return ppq; }
        }

        public ISongMeasure getSongPerformanceMeasure(int measure)
        {
            return getPerformanceMeasure(measure - 1);
        }

        public void addTrack(ISongTrack track)
        {
            tracks.Add(track);
        }

        public int TrackCount
        {
            get { return tracks.Count; }
        }

        public ISongTrack getTrack(int index)
        {
            return tracks[index - 1];
        }

        public Tempo Tempo
        {
            get { return tempo; }
        }
    }
}
