﻿using System;
using System.Collections;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongMeasureImpl : ISongMeasure
    {
        private readonly int length;
        private readonly int index;
        private readonly TimeSignature timeSignature;
        private readonly Hashtable trackHash;

        public SongMeasureImpl(int index, int length, TimeSignature timeSignature)
        {
            this.index = index;
            this.length = length;
            this.timeSignature = timeSignature;

            trackHash = new Hashtable();
        }

        #region ISongMeasure Members

        public void addTrack(ISongMeasureTrack track)
        {
            trackHash.Add(track.Track, track);
        }

        public ISongMeasureTrack getTrack(ISongTrack track)
        {
            return (ISongMeasureTrack)trackHash[track];
        }

        public int getLength()
        {
            return length;
        }

        public int getIndex()
        {
            return index;
        }

        public TimeSignature getTimeSignature()
        {
            return timeSignature;
        }

        #endregion

        #region ISongPhrase Members

        public int getScoreMeasureCount()
        {
            return 1;
        }

        public ISongMeasure getScoreMeasure(int measure)
        {
            if (measure == 0)
                return this;
            
            throw new IndexOutOfRangeException();
        }

        public int getPerformanceMeasureCount()
        {
            return 1;
        }

        public ISongMeasure getPerformanceMeasure(int measure)
        {
            if (measure == 0)
                return this;
            
            throw new IndexOutOfRangeException();
        }

        #endregion
    }
}
