﻿using System.Collections.Generic;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongMeasureTrackImpl : ISongMeasureTrack
    {
        readonly ISongTrack track;
        readonly List<ISongVirtualTrack> virtualTracks;

        public SongMeasureTrackImpl(ISongTrack track)
        {
            this.track = track;

            virtualTracks = new List<ISongVirtualTrack>(track.VirtualTrackCount);

            for (int i = 0; i < track.VirtualTrackCount; i++)
                virtualTracks.Add(new SongVirtualTrackImpl(this, i));
        }

        private static int sortByTime(ISongEvent s1, ISongEvent s2)
        {
            return s1.Time - s2.Time;
        }

        #region ISongMeasureTrack Members

        public ISongVirtualTrack getVirtualTrack(int trackID)
        {
            return virtualTracks[trackID];
        }

        public List<ISongEvent> Events
        {
            get 
            { 
                List<ISongEvent> tempList = new List<ISongEvent>();
                for (int i = 0; i < virtualTracks.Count; i++)
                {
                    ISongVirtualTrack svt = virtualTracks[i];
                    foreach (ISongEvent se in svt.Events)
                        tempList.Add(se);
                }

                tempList.Sort(sortByTime);

                return tempList;
            }
        }

        public ISongTrack Track
        {
            get { return track; }
        }

        #endregion
    }
}
