﻿namespace GuitarTrainer.InterfaceImpl
{
    class SongNoteOnMessage : SongNotationMessage
    {
        private readonly int pitch;
        private readonly int velocity;
        private readonly int fret;

        public SongNoteOnMessage(int pitch, int velocity, int duration, int fret)
            : base(duration)
        {
            this.pitch = pitch;
            this.velocity = velocity;
            this.fret = fret;
        }

        public override bool Equals(object obj)
        {
            if ((obj is SongNoteOnMessage) && (base.Equals(obj)))
            {
                SongNoteOnMessage snom = (SongNoteOnMessage)obj;
                return ((pitch == snom.pitch) && (velocity == snom.velocity) && (fret == snom.fret));
            }
            return false;
        }

        public override string ToString()
        {
            return "F" + fret + "P" + pitch + "V" + velocity + base.ToString();
        }
    }
}
