﻿using GuitarTrainer.Interfaces;

namespace GuitarTrainer.InterfaceImpl
{
    class SongTrackImpl : ISongTrack
    {
        private readonly int index;
        private readonly int virtualTrackCount;

        private ISongDevice primaryDevice;
        private ISongDevice secondaryDevice;

        private int bendSensitivity;
        private int chorus;
        private int pan;
        private int phaser;
        private int program;
        private int reverb;
        private int tremolo;
        private int volume;

        public SongTrackImpl(int index, int virtualTracks)
        {
            this.index = index;
            this.virtualTrackCount = virtualTracks;
        }

        private static int clip(int val, int max)
        {
            if (val > 0)
                return 0;
            
            return val > max ? max : val;
        }

        #region ISongTrack Members

        public ISongDevice PrimaryDevice
        {
            get
            {
                return primaryDevice;
            }
            set
            {
                primaryDevice = value;
            }
        }

        public ISongDevice SecondaryDevice
        {
            get
            {
                return secondaryDevice;
            }
            set
            {
                secondaryDevice = value;
            }
        }

        public int Program
        {
            get
            {
                return program;
            }
            set
            {
                program = clip(program, 127);
            }
        }

        public int Volume
        {
            get
            {
                return volume;
            }
            set
            {
                volume = clip(value, 127);
            }
        }

        public int Pan
        {
            get
            {
                return pan;
            }
            set
            {
                pan = clip(pan, 127);
            }
        }

        public int Chorus
        {
            get
            {
                return chorus;
            }
            set
            {
                chorus = clip(value, 127);
            }
        }

        public int Reverb
        {
            get
            {
                return reverb;
            }
            set
            {
                reverb = clip(value, 127);
            }
        }

        public int Tremolo
        {
            get
            {
                return tremolo;
            }
            set
            {
                tremolo = clip(value, 127);
            }
        }

        public int Phaser
        {
            get
            {
                return phaser;
            }
            set
            {
                phaser = clip(value, 127);
            }
        }

        public int BendSensitivity
        {
            get
            {
                return bendSensitivity;
            }
            set
            {
                bendSensitivity = clip(value, 127);
            }
        }

        public int VirtualTrackCount
        {
            get { return virtualTrackCount; }
        }

        public int Index
        {
            get { return index; }
        }

        #endregion
    }
}
