﻿namespace GuitarTrainer.Interfaces
{
    class TimeSignature
    {
        private readonly int numerator;
        private readonly int denominator;

        public TimeSignature(int numerator, int denominator)
        {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public int Denominator
        {
            get { return denominator; }
        }

        public override string ToString()
        {
            return numerator + "/" + denominator;
        }

        public override bool Equals(object obj)
        {
            if (obj is TimeSignature)
            {
                TimeSignature ts = (TimeSignature)obj;
                return ((numerator == ts.numerator) && (denominator == ts.denominator));
            }
            
            return false;
        }

        public override int GetHashCode()
        {
            return ToString().GetHashCode();
        }
    }
}
