﻿using System.Collections.Generic;
using GuitarTrainer.Interfaces;

namespace GuitarTrainer.Sound
{
    class DefaultArrangement : IArrangement
    {
        readonly List<int> measures;

        public DefaultArrangement(ISongPhrase song)
        {
            int measureCount = song.getPerformanceMeasureCount();
            measures = new List<int>(measureCount);
            for (int i = 0; i < measureCount; i++)
                measures.Add(i);
        }

        public List<int> MeasureList
        {
            get { return measures; }
        }
    }
}
