# photoapp_urls.py
# urls specific for photoapp

from django.conf.urls.defaults import *
from django.contrib.auth.views import login, logout

urlpatterns = patterns('photosite.photoapp.views',
    # Example:
    # (r'^photosite/', include('photosite.foo.urls')),

    url(r'^home/$|^$', 'home_page', name='home_page'),
    url(r'^photographer/(?P<author_name>\S{1,30})/$', 'photographer', name='photographer'),
    url(r'^upload/$', 'upload_file', name='upload_file')
)

urlpatterns += patterns('',
    (r'^login/$',  login, {'template_name': 'registration/login.html', 'redirect_field_name': '/home'}),
    (r'^logout/$', logout, {'next_page': '/home'}),
)

#####################################################################################################
