package objects.AI;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Material;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import main.AmmoManager;
import main.TerrainManager;

import objects.DynamicObject;
import objects.DynamicObjectManager;
import objects.Effects.AIBehavior;

import utils.Logger;

import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickTool;

public class AISpawner implements DynamicObject
{
	// obstacle dimensions (for both block-like things and cylinders)
	private final static float RADIUS = 0.5f;
	// for a block, RADIUS == length of a side/2
	private final static float HEIGHT = 1.0f;
	
	private final static Color3f grey = new Color3f(0.50f, 0.50f, 0.50f);
	private final static Color3f white = new Color3f(01.0f, 01.0f, 01.0f);
	private final static Color3f medgreen = new Color3f(0.0f, 0.7f, 0.1f);
	
	// textures used for the obstacles
	private final static String CYL_TEX = "images/cobbles.jpg";
	
	private Appearance cylinderAppearance;   // obstacle appearances
	private Vector3d temporaryVector;
	private Logger log;
	private PickTool pickTool;

	public AISpawner(Logger log, PickTool pickTool)
	{
		this.log = log;
		this.pickTool = pickTool;
		
	    // the Appearance nodes used by all the blocks and cylinders
	    cylinderAppearance = makeAppearance(medgreen, CYL_TEX);       // green texture for cylinders
	}
	
	public TransformGroup getObject(char type, double z, double x, int y) 
	{
		
		Primitive obstical = null;
		
		obstical = new Cylinder(RADIUS, HEIGHT*2, 
				Primitive.GENERATE_TEXTURE_COORDS |
				Primitive.GENERATE_NORMALS, cylinderAppearance );
		temporaryVector = new Vector3d(x, y, z);
	    
	    // position the obstacle so its base is resting on the floor at (x,z)
	    TransformGroup positionTransformGroup = new TransformGroup();
	    Transform3D transform3D = new Transform3D();
	    transform3D.setTranslation( temporaryVector );  // move up
	    positionTransformGroup.setTransform(transform3D);
	    
	    // Create a bounds for the background and behaviors
		BoundingSphere bounds =
			new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
		
	    TransformGroup objTrans1 = new TransformGroup();
		objTrans1.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		TransformGroup objTrans2 = new TransformGroup();
		objTrans2.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objTrans1.addChild(objTrans2);
		
		// Create a new Behavior object that will perform the desired
		// rotation on the specified transform object and add it into
		// the scene graph.
		Transform3D yAxis1 = new Transform3D();
		yAxis1.rotY(2*Math.PI);
		Alpha twerlingAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
						Alpha.DECREASING_ENABLE,
						0, 0,
						5000, 2500, 200,
						5000, 2500, 200);

		RotationInterpolator twerlingTower =
		    new RotationInterpolator(twerlingAlpha, objTrans1, yAxis1,
					     -(float) Math.PI/2.0f,
					     (float) Math.PI/2.0f);
		twerlingTower.setSchedulingBounds(bounds);
		objTrans2.addChild(twerlingTower);
		objTrans2.addChild(obstical);
	    positionTransformGroup.addChild(objTrans1); 
	    return positionTransformGroup;
	}
	
	private Appearance makeAppearance(Color3f color, String texture_file_name)
	{
		Appearance appearance = new Appearance();

	    // mix the texture and the material color
	    TextureAttributes textureAttributes = new TextureAttributes();
	    textureAttributes.setTextureMode(TextureAttributes.MODULATE);
	    appearance.setTextureAttributes(textureAttributes);

	    // load and set the texture
	    log.println("Loading obstacle texture from " + texture_file_name);
	    TextureLoader loader = new TextureLoader(texture_file_name, null);
	    Texture2D texture = (Texture2D) loader.getTexture();
	    appearance.setTexture(texture);      // set the texture

	    // add a coloured material
	    Material material = new Material(color, grey, color, white, 20.f);
	    material.setLightingEnable(true);
	    appearance.setMaterial(material);
	    return appearance;
	}  // end of makeAppearance()

	@Override
	public void collidingEffectOn(DynamicObject data) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public int doDamage(int[] damage) 
	{
		return 0;
		//does no damage
	}

	@Override
	public Vector3d getPosition() {
		return null;
	}

	@Override
	public double getRange() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}
}
