package objects.AI;

/**
 * This is the brain holding the AI's Instincts
 * 
 * @author Jeremiah Lewis
 *
 */
public class Instinct implements Cloneable 
{
	// 100ms is a cycle *10 cycles is a second *60 seconds is a minute *5 minutes
	public static final int MAX_TIME_TO_LIVE = 10*60*5; 
	
    // probability of each battle state
    // (the sum should be 1)
    public double chanceToRun;
    public double chanceToCharge;
    public double chanceToRangedAttack;
    public double chanceToLayTrap;
    public double chanceToEnchant;

    public long decisionTime;
    public boolean alive = false;


    public void fixProbabilites() {
        // make the sums of the odds == 1.
        float sum = (float) (chanceToRun + chanceToCharge + chanceToRangedAttack + chanceToLayTrap + chanceToEnchant);
        if (sum > 0) {
        	chanceToRun /= sum;
        	chanceToCharge /= sum;
        	chanceToRangedAttack /= sum;
        	chanceToLayTrap /= sum;
        	chanceToEnchant /= sum;
        }
    }

    public Instinct() {}

    /**
        Copy constructor.
    */
    public Instinct(Instinct brain) {
    	chanceToRun = brain.chanceToRun;
    	chanceToCharge = brain.chanceToCharge;
    	chanceToRangedAttack = brain.chanceToRangedAttack;
    	chanceToLayTrap = brain.chanceToLayTrap;
    	chanceToEnchant = brain.chanceToEnchant;

        decisionTime = brain.decisionTime;
    }

    public Object clone() {
        return new Instinct(this);
    }

    public String toString() 
    {
        return
            "DecisionTime: " + decisionTime + "\n" +

            "chanceToRun: " + chanceToRun + "\n" +
            "chanceToCharge: " + chanceToCharge + "\n" +
            "chanceToRangedAttack: " + chanceToRangedAttack +  "\n" +
            "chanceToLayTrap: " + chanceToLayTrap +  "\n" +
            "chanceToEnchant: " + chanceToEnchant;
    }
}
