package objects.AI;

import java.util.ArrayList;

import javax.vecmath.Point3d;

public class Node 
{
	private int node;
	private ArrayList< Integer > children;
	private ArrayList< Integer > costs;
	private Point3d point;

	public Node( int node, Point3d point ) 
	{
		this.node = node;
		this.point = point;
		costs = new ArrayList< Integer >();
		children = new ArrayList< Integer >();
	}

	public int getNodeNumber() {
		return node;
	}

	public ArrayList<Integer> getChildren() {
		return children;
	}

	public synchronized ArrayList<Integer> getCosts() {
		return costs;
	}

	public synchronized void setCosts(ArrayList<Integer> costs) {
		this.costs = costs;
	}
	
	public String print()
	{
		String string = "node " + node + " ("+point.z+","+point.x+") to";
		for( int i = 0; i < children.size() && i < costs.size(); i++ )
		{
			string += " node " + children.get( i ) + ", costs " + costs.get( i ) + " and";
		}
		
		return string;
	}

	public void setChildren( String[] split ) 
	{
		for( String number :split )
		{
			if( !number.equalsIgnoreCase( ""+node ) )
			{
				children.add( Integer.parseInt( number ) );
				costs.add( NodeTree.NULL_COST_VALUE );
			}
		}
	}
}
