package objects;

import java.util.Enumeration;

import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.PickInfo;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;

import utils.Logger;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.pickfast.PickTool;

public class CollisionDetector extends Behavior
{
	private final long TIME_BETWEEN_REACTING = 5000;
	private WakeupOnCollisionEntry enter;
	private WakeupOnElapsedTime contact;
	private WakeupOnCollisionExit exit;
	private WakeupOr timeOrExit;
	private Primitive shape;
	private PickTool picker;
	private Point3d pickStart = new Point3d( 0, 0, 0 );
	private Object data;
	private Logger log;
	
	public CollisionDetector( BranchGroup branchGroup, Primitive shape, Bounds boundingObject, Logger log )
	{
		picker = new PickTool( branchGroup );
		picker.setShapeBounds( boundingObject, pickStart );
		this.shape = shape;
		this.log = log;
	}
	
	@Override
	public void initialize() 
	{
		enter = new WakeupOnCollisionEntry( shape );
		contact = new WakeupOnElapsedTime(TIME_BETWEEN_REACTING);
		exit = new WakeupOnCollisionExit( shape );
		timeOrExit = new WakeupOr( new WakeupCriterion[] { contact, exit } );
		wakeupOn(enter);
	}
	
	@Override
	public void processStimulus( Enumeration arg0 ) 
	{
		WakeupCriterion wakeup;
		while( arg0.hasMoreElements() ) 
		{
			wakeup = (WakeupCriterion) arg0.nextElement();
			log.println( "why collision triggered: "+wakeup.getClass(), Logger.NOTE+Logger.COLLISION );
		
			if( wakeup instanceof WakeupOnCollisionExit )
			{
				wakeupOn(enter);
			}
			else if ( enter.hasTriggered() ) 
			{
				PickInfo picked = picker.pickClosest();
				log.println( "why collision triggered: "+wakeup.getClass(), Logger.NOTE+Logger.COLLISION );
				data = null;
				if( picked != null )
				{
					data = picked.getNode().getUserData();
				}
				
				if( data != null && data instanceof DynamicObject )
				{
					log.println( "collision detected with a dynamic object", Logger.NOTE+Logger.COLLISION );
					// need to write the dealDamage() in here somewhere.
					((DynamicObject) shape.getUserData()).collidingEffectOn((DynamicObject) data);
					wakeupOn(contact);
				}
				else
				{
					log.println( "collision detected with a static object", Logger.NOTE+Logger.COLLISION );
					return;
				}
			}
			else if( contact.hasTriggered() )
			{
				((DynamicObject) shape.getUserData()).collidingEffectOn((DynamicObject) data);
				wakeupOn( timeOrExit );
			}
		}
	}
}
