package objects.Effects;

import java.util.Enumeration;

import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;

import objects.AI.AI;

public class AIBehavior extends Behavior
{
	// the wake up condition for the behavior
	protected WakeupCondition wakeupCondition = null;
	private AI ai;

	public AIBehavior( int delay, AI ai )
	{
		this.ai = ai;

		// save the WakeupCriterion for the behavior
		wakeupCondition = new WakeupOnElapsedTime( delay );
	}

	public void initialize()
	{
		// register WakeupCondition
		wakeupOn( wakeupCondition );
	}

	public void processStimulus( Enumeration criteria )
	{				
		// ignore criteria
	    ai.update();
	    wakeupOn( wakeupCondition ); // re-register WakeupCondition
	}
}
