package objects.Effects;

import java.util.Enumeration;

import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedTime;

import objects.AI.EvolutionGenePool;

public class GenePoolBehavior extends Behavior
{
	// the wake up condition for the behavior
	protected WakeupCondition wakeupCondition = null;
	private EvolutionGenePool genePool;

	public GenePoolBehavior( int delay, EvolutionGenePool genePool )
	{
		this.genePool = genePool;

		// save the WakeupCriterion for the behavior
		wakeupCondition = new WakeupOnElapsedTime( delay );
	}

	public void initialize()
	{
		// register WakeupCondition
		wakeupOn( wakeupCondition );
	}

	public void processStimulus( Enumeration criteria )
	{				
		// ignore criteria
	    genePool.update();
	    wakeupOn( wakeupCondition ); // re-register WakeupCondition
	}
}
