package objects.Factories;

import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.PlatformGeometry;

import objects.DynamicObjectManager;
import objects.AI.EvolutionGenePool;
import objects.Spells.Spell;
import utils.Logger;

import main.AmmoManager;
import main.TerrainManager;

public abstract class Factory 
{	
	/** This creates an object like a wall or a pillar or most floors*/
	private static StaticFactory staticF = new StaticFactory();

	public static Node getStaticObject(char characterRepresention, double z, double x, int y, PickTool pickTool) 
	{
		return staticF.getObject(characterRepresention, z, x, y, pickTool);
	}

	public static Spell getSpell(TransformGroup steerTransformGroup, String type, TerrainManager terrain, Logger log, 
			DynamicObjectManager objectManager) 
	{
		return SpellFactory.getSpell(steerTransformGroup, type, terrain, log, objectManager);
	}

	public static Node getPlayer( PlatformGeometry platformGeometry, Logger log,
			DynamicObjectManager objectManager, AmmoManager ammoManager, TerrainManager terrain ) 
	{
		return PlayerSpawner.getAvatar( platformGeometry, log, objectManager, ammoManager, terrain );
	}

	public static Node getAISpawner( char characterAtPosition, double z,
			double x, int y, Logger log, PickTool pickTool ) 
	{
		return AISpawnerFactory.getObject(characterAtPosition, z, x, y, log, pickTool );
	}

	public static Node getNormalAI( Vector3d position, Logger log,
			DynamicObjectManager objectManager, AmmoManager ammoManager, TerrainManager terrain, PickTool pickTool, int aiNumber, EvolutionGenePool genePool ) 
	{
		return AIFactory.createNormalAI( position, log, objectManager, ammoManager, terrain, pickTool, aiNumber, genePool );
	}
}
