package objects.Factories;

import javax.media.j3d.TransformGroup;

import objects.DynamicObjectManager;
import objects.Spells.Enchant;
import objects.Spells.FireEnchant;
import objects.Spells.FireSpell;
import objects.Spells.FireTrap;
import objects.Spells.Spell;
import objects.Spells.Trap;
import utils.Logger;

import main.TerrainManager;

public class SpellFactory extends Factory 
{

	public static Spell getSpell(TransformGroup steerTransformGroup, String type, TerrainManager terrain, Logger log, 
			DynamicObjectManager objectManager)
	{
		if( type.equalsIgnoreCase( "fire" ) )
		{
			return new FireSpell( steerTransformGroup, terrain, log, objectManager );
		}
		else
		{
			return null;
		}
	}
	
	public static Trap createTrap(TransformGroup steerTransformGroup, String type, TerrainManager terrain, Logger log)
	{
		if( type.equalsIgnoreCase( "fire" ) )
		{
			return new FireTrap( steerTransformGroup, terrain, log, null ); // TODO there is a null here that needs to be taken care of
		}
		else
		{
			return null;
		}
	}
	
	public static Enchant createEnchant(TransformGroup steerTransformGroup, String type, TerrainManager terrain, Logger log)
	{
		if( type.equalsIgnoreCase( "fire" ) )
		{
			return new FireEnchant( steerTransformGroup, terrain, log );
		}
		else
		{
			return null;
		}
	}
}
