package objects.Spells;

import java.util.Hashtable;

import javax.media.j3d.TransformGroup;

import main.TerrainManager;
import utils.Logger;

public class Enchant 
{
	private int[] damage;
	private Hashtable< Integer, Integer > protection;
	
	public Enchant( TransformGroup steerTransformGroup, TerrainManager terrain,
			Logger log ) 
	{
		damage = new int[] { 0, 0, 0, 1 };
		protection = new Hashtable< Integer, Integer >();
	}

	/**
	 * The amount of damage this type of enchantment inflicts when you ram someone with it on.
	 * @return
	 */
	public int[] getDamageToInflict() {
		// TODO Auto-generated method stub
		return new int[] { 0, 0 };
	}

	/**
	 * The amount of damage this type of enchantment prevents from happening when a collision is
	 * detected, be it from an explosion-class or a ramming-class attack.
	 * @param damage2 
	 * @return
	 */
	public int getDamageToPrevent( int[] damage2 ) 
	{
		int armor = 0;
		
		for ( int i = 0; i < damage2.length; i += 2 ) 
		{
			if ( protection.contains( damage2[i+1] ) ) 
			{
				armor += protection.get( damage2[i+1] );
			}
		}
		
		return armor;
	}
}
