package objects.Spells;

import javax.media.j3d.*;
import javax.vecmath.*;

import objects.DynamicObjectManager;

import utils.Logger;

import main.TerrainManager;


public class FireSpell extends Spell
{
  private static final String TYPE = "fire";     // the type of spell this is

  // for repeated calculations

  public FireSpell(TransformGroup steerTransformGroup, TerrainManager terrain, Logger log, DynamicObjectManager objectManager)
  {
	  super(steerTransformGroup, TYPE, terrain, log, objectManager);
   }  // end of FireSpell()

protected Appearance makeAppearance()
  {
    Color3f mediumRed = new Color3f(1f, 0.4f, 0.3f);
    Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    Color3f specular = new Color3f(0.9f, 0.9f, 0.9f);

    Material redMaterial = new Material(mediumRed, black, mediumRed, specular, 80.0f);
    redMaterial.setLightingEnable(true);
    
    Appearance redAppearance = new Appearance();
    redAppearance.setMaterial(redMaterial);
    return redAppearance;
  } // end of makeAppearance()


  // ------------------------ shot methods ----------------





  // -------------------- for debugging ---------------------




}  // end of LaserShot class
