package utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;

/**
 * Logger Class<br/>
 * <br/>
 * <b>Function:</b><br/>
 * This class is used to take output from the various classes and display or 
 * store it in various ways.  Only the types of output that have their flags
 * set will be displayed or stored.<br/>
 * <br/>
 * <br/>
 * <b>Logger Modes</b><br/>
 * NOTE = 4<br/>
 * WARNING = 8<br/>
 * EXCEPTION = 16<br/>
 * <br/>
 * <b>Output Modes</b><br/>
 * OUT_TO_FILE = 1<br/>
 * OUT_TO_WINDOW = 2<br/>
 * <br/>
 * <B>Sections</B><br/>
 * <br/>
 * <b>Special</b><br/>
 * NONE = 0<br/>
 * ALL = 31<br/>
 * <br/>
 * <br/>
 * <b>Last Change: </b><br/>
 * 01.29.2010 - jjlewis - created<br/>
 * <br/>
 * @author jjlewis
 * @version 1.0
 */
public class Logger {
//----------------------------------------------------------------------------
// Constants
//----------------------------------------------------------------------------
	
	//Logger modes ('int's so can be combined)
	/** Forms of output*/
	public final static int NONE = 1;
	public final static int OUT_TO_FILE = 2;	// This is to send the output to a file for later perusal
	public final static int OUT_TO_WINDOW = 4;	// This is the default output for errors and the like
	
	/** Types of messages*/
	public final static int DEBUG = 8;
	public final static int NOTE = 16;
	public final static int WARNING = 32;
	public final static int EXCEPTION = 64;
	
	/** Output with regards to*/
	public final static int PROPERTIES = 128;
	public final static int TERRAIN_GENERATION = 256;
	public final static int SPELL = 512;
	public final static int TRAP = 1024;
	public final static int ENCHANT = 2048;
	public final static int OBJECT_MANAGER = 4096;
	public static final int TREE = 4096*2;
	public static final int COLLISION = (4096*2)*2;
	public final static int ALL = COLLISION-1;
	
//----------------------------------------------------------------------------
// Class variables
//----------------------------------------------------------------------------
	
	private static int mode = 0;
	private static boolean overWrite = false; // paradoxialy, this means that you want to overwrite
	
	//The output stream
	private static PrintStream logOutput;
	private static String currentDate;
	
//----------------------------------------------------------------------------
// Constructors
//----------------------------------------------------------------------------


	public Logger(int outputTypes)
	{
		mode = outputTypes;
		Calendar date = Calendar.getInstance();
		currentDate = date.get(Calendar.YEAR)+"-"+(date.get(Calendar.MONTH)+1)+"-"+date.get(Calendar.DAY_OF_MONTH);
		File fileName = new File("./logs/"+currentDate+".log");//
		
		if(fileName.exists())
		{
			overWrite = true;
		}
		else
		{
			try {
				fileName.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
			overWrite = false;
		}
		
		try {
			logOutput = new PrintStream(new FileOutputStream(fileName, overWrite));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}
	
//----------------------------------------------------------------------------
// Public Methods
//----------------------------------------------------------------------------
	
	public void print(String output, int outputType)
	{
		if( ( outputType & mode ) > 0 )
		{
			if ( ( Logger.OUT_TO_FILE & mode ) > 0 ) {
				if( ( Logger.EXCEPTION & mode ) > 0 && ( Logger.EXCEPTION & outputType) > 0 ) 
				{
					//logOutput.print("ERROR - "+output);
				}
				else if( ( Logger.WARNING & mode) > 0 && (Logger.WARNING & outputType) > 0 )
				{
					//logOutput.print("**"+output);
				}
				else if( ( Logger.NOTE & mode) > 0 && (Logger.NOTE & outputType) > 0 )
				{
					//logOutput.print(output);
				}
			}
			
			if( ( Logger.OUT_TO_WINDOW & mode ) > 0 )
			{
				if ( ( Logger.EXCEPTION & mode ) > 0 && ( Logger.EXCEPTION & outputType) > 0 ) 
				{
					// System.err.print(output);
				}
				else if ( ( Logger.WARNING & mode ) > 0 && ( Logger.WARNING & outputType) > 0 )
				{
					// System.out.print("**"+output);
				}
				else if ( ( Logger.NOTE & mode ) > 0 && ( Logger.NOTE & outputType) > 0 ) 
				{
					// System.out.print(output);
				}
			}
		}
	}
	
	public void println(String output, int outputType){
		print(output+"\n",outputType);
	}

	public void println(String output) {
		println(output, Logger.NOTE);
	}
	
	public void close()
	{
		logOutput.close();
	}
	
	public void changeMode(int newMode)
	{
		mode = newMode;
	}
	
	public int getMode()
	{
		return mode;
	}

	public static String printLevels() {
		// TODO Auto-generated method stub
		return null;
	}
}
