/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class Frame
extends JFrame
implements FileFilter {
    private Image image = Toolkit.getDefaultToolkit().getImage("/rock1.jpg");
    private BufferedImage imageTemp = null;
    private boolean toggled = false;
    private boolean pictureLoaded = false;
    private int rgbColor = Color.RED.getRGB();
    private int percentage = 0;
    private int overall = 0;
    private int row = 0;
    private Color[] suggestedColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.PINK, Color.YELLOW, Color.CYAN};
    private int colorIndex = 0;
    private Color color = Color.RED;
    private int[][] processedPixels;
    private int[] percentages = new int[10];
    private final String[] okFileExtensions = new String[]{"jpg", "png", "gif"};
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSlider jSlider1;
    private JTable jTable2;
    private JTextField jTextField1;

    public Frame() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension dimension = tk.getScreenSize();
        this.setPreferredSize(dimension);
        this.initComponents();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jTextField1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jButton4 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel4 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("GeoPixel Counter");
        this.jButton1.setText("Load");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("1. Select Image File.");
        this.jLabel2.setText("<HTML>2. Select grain replacement color (an color not on the image).</HTML>");
        this.jButton2.setText("Select");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("<HTML>3. Select grain and adjust degree of color match </HTML>");
        this.jButton3.setText("Select");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel5.setOpaque(true);
        this.jLabel5.setBackground(Color.RED);
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setPaintLabels(true);
        this.jProgressBar1.setStringPainted(true);
        if (!this.toggled) {
            this.jLabel6.setText(" ");
        }
        this.jLabel6.setText(" ");
        this.jLabel6.setAutoscrolls(true);
        if (this.toggled) {
            this.jLabel6.setText("Please select a grain");
        }
        this.jTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Mineral", "Color", "# of Pixels", "Percentage"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Object.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable2.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jLabel7.setText("4. Name Mineral, Add to list and repeat at Step 2.  ");
        this.jLabel8.setText("Name:");
        this.jButton4.setText("Add to list");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setAutoscrolls(true);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setVerticalAlignment(1);
        this.jLabel4.setAutoscrolls(true);
        this.jLabel4.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Frame.this.jLabel4MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLabel4);
        this.jMenu1.setText("File");
        this.jMenu1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jMenu1ActionPerformed(evt);
            }
        });
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Help");
        this.jMenu2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jMenu2ActionPerformed(evt);
            }
        });
        this.jMenuItem2.setText("About");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("About");
        this.jMenuItem3.setText("About");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Frame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jProgressBar1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5, -2, 37, -2)).addComponent(this.jSlider1, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1).addComponent(this.jLabel2, -1, 147, Short.MAX_VALUE).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jLabel3, 0, 0, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField1, -2, 81, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jButton4)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 226, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -2, 160, -2).addComponent(this.jScrollPane1, -1, 1035, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel6, -1, 56, Short.MAX_VALUE).addGap(7, 7, 7).addComponent(this.jScrollPane1, -2, 440, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 8, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider1, -2, 43, -2).addGap(3, 3, 3).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    public void paintComponent(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
    }

    public void setjLabel6(JLabel jLabel6) {
        this.jLabel6 = jLabel6;
    }

    public boolean accept(File file) {
        for (String extension : this.okFileExtensions) {
            if (!file.getName().toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(this.jButton1);
        String filePath = chooser.getSelectedFile().getAbsolutePath();
        if (!this.accept(chooser.getSelectedFile())) {
            JOptionPane.showMessageDialog(null, "Not a supported file type.  The program can read .gif, .jpg, .png");
        } else {
            this.image = Toolkit.getDefaultToolkit().getImage(filePath);
            this.jLabel4.setIcon(new ImageIcon(filePath));
            this.pictureLoaded = true;
            this.imageTemp = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 1);
            Graphics2D g = this.imageTemp.createGraphics();
            g.drawImage(this.image, 0, 0, null);
            this.processedPixels = new int[this.imageTemp.getTileWidth()][this.imageTemp.getTileHeight()];
            System.out.println(this.processedPixels.length);
        }
    }

    private void jMenu1ActionPerformed(ActionEvent evt) {
    }

    private void jMenu2ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        int returnVal = JOptionPane.showConfirmDialog(null, "Really want to quit?");
        if (returnVal == 0) {
            System.exit(0);
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(null, "To be implemented!");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JColorChooser chooser = new JColorChooser();
        Color newColor = JColorChooser.showDialog(chooser, null, this.jLabel5.getBackground());
        this.rgbColor = newColor.getRGB();
        this.color = newColor;
        if (newColor != null) {
            this.jLabel5.setBackground(newColor);
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(null, "A project created by Julian Bertmaringbased on an existing Program by Kenrick Mock and Concept/Design by Jeff Amato.");
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.pictureLoaded) {
            this.toggled = true;
            this.jLabel6.setText("<HTML> Please select a grain </HTML>");
        }
    }

    private void jLabel4MouseClicked(MouseEvent evt) {
        if (this.toggled && this.pictureLoaded) {
            int x = evt.getX();
            int y = evt.getY();
            System.out.println(x);
            System.out.println(y);
            int rgb = this.imageTemp.getRGB(x, y);
            BufferedImage imageTempNew = new BufferedImage(this.image.getWidth(null), this.image.getHeight(null), 1);
            Graphics2D gNew = imageTempNew.createGraphics();
            gNew.drawImage(this.image, 0, 0, null);
            System.out.println(rgb);
            this.jProgressBar1.setMaximum(100);
            int slider = this.jSlider1.getValue() * 100;
            int dummy = rgb;
            int difference = 0;
            int counter = 0;
            for (int xNew = this.imageTemp.getMinX(); xNew < this.imageTemp.getTileWidth(); ++xNew) {
                for (int yNew = this.imageTemp.getMinY(); yNew < this.imageTemp.getTileHeight(); ++yNew) {
                    difference = Math.abs(this.imageTemp.getRGB(xNew, yNew)) - Math.abs(rgb);
                    this.jProgressBar1.setValue((1 - --dummy) / rgb / 100);
                    this.jProgressBar1.setStringPainted(true);
                    if (this.processedPixels[xNew][yNew] == 1 || difference >= slider) continue;
                    imageTempNew.setRGB(xNew, yNew, this.rgbColor);
                    ++counter;
                    this.processedPixels[xNew][yNew] = 1;
                }
            }
            this.percentage = counter;
            System.out.println("test");
            this.image = imageTempNew;
            this.jLabel4.setIcon(new ImageIcon(this.image));
            this.toggled = false;
            this.jLabel6.setText(" ");
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        System.out.println(this.jTable2.getRowCount());
        String mineral = this.jTextField1.getText();
        this.overall = this.percentage + this.overall;
        int numberOfPixels = this.percentage;
        this.percentages[this.row] = this.percentage;
        this.jTable2.setValueAt(mineral, this.row, 0);
        this.jTable2.setValueAt(this.color, this.row, 1);
        this.jTable2.setValueAt(numberOfPixels, this.row, 2);
        for (int i = 0; i <= this.row; ++i) {
            this.jTable2.setValueAt(100 * this.percentages[i] / this.overall, i, 3);
        }
        ++this.row;
        this.jTable2.revalidate();
        ++this.colorIndex;
        if (this.colorIndex > this.suggestedColors.length) {
            this.colorIndex = 0;
        }
        this.jLabel5.setBackground(this.suggestedColors[this.colorIndex]);
        this.rgbColor = this.suggestedColors[this.colorIndex].getRGB();
        this.color = this.suggestedColors[this.colorIndex];
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Frame().setVisible(true);
            }
        });
    }
}

