/*
 * GeoPixelCounter revision by Julian Bertmaring - contact jbertmaring@uaa.alaska.edu
 * V 1.0
 *
 * This program lets the user load in an image and then replace pixles based on
 * selected colors with a different color. This allows the user to calculate percentages
 * of different colors that appear in the loaded image and shows which colors already got replaced
 * by drawing new colors over the already selected ones.
 * 
 */

/*
 * Things to do:
 * Make the slider bar adjustable and have grains being replaced while doing so
 * Create a zoom function for the picture
 * Adjust the picture location
 * Round percentages up
 * Create a save function
 */


import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.Toolkit;
import java.io.*;
import javax.swing.JLabel;

/*
 * Main class Frame which includes all the UI + functionality methods
 */

public class Frame extends javax.swing.JFrame implements FileFilter{

   /*
    * Variable declaration block
    */
   //set the image to a default image
   private Image image = Toolkit.getDefaultToolkit().getImage("/rock1.jpg");
   //create a buffered image but keep it empty for now
   private BufferedImage imageTemp = null;
   //keep track if you are in grain replacement mode or not
   private boolean toggled = false;
   //boolean to keep track whether a picture is loaded or not
   private boolean pictureLoaded = false;
   //create a default color with rgb (throughout the process keeps track of the rgb of the color)
   private int rgbColor = java.awt.Color.RED.getRGB();
   //keep track of how many pixels there are (used for percentage calculation)
   private int percentage = 0;
   //keep track of the overall pixel count at this stage (used for percentage calculation)
   private int overall = 0;
   //keep track of how many grain replacements got made (used for the table)
   private int row = 0;
   //array of suggested colors for replacements
   private Color[] suggestedColors = {Color.RED, Color.GREEN, Color.BLUE, Color.PINK, Color.YELLOW, Color.CYAN};
   //index of colors used for the suggested color array
   private int colorIndex = 0;
   //set the default color to red to start with (throughout the process keeps track of what color)
   private Color color = java.awt.Color.RED;
   //array to keep track of which pixels are processed already
   private int[][] processedPixels;
   //keep track of the number of pixels of each grain replacement (used for percentage calculation)
   private int[] percentages = new int[10];

   /** Creates new form Frame */
    public Frame() {

       Toolkit tk = Toolkit.getDefaultToolkit();
       java.awt.Dimension dimension = tk.getScreenSize();
       setPreferredSize(dimension);
       initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     *
     * This is autogenerated code which can be edited via NetBeans UI
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jButton2 = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jProgressBar1 = new javax.swing.JProgressBar();
        jLabel6 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        jTextField1 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jButton4 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jLabel4 = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenu3 = new javax.swing.JMenu();
        jMenuItem3 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("GeoPixel Counter");

        jButton1.setText("Load");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel1.setText("1. Select Image File.");

        jLabel2.setText("<HTML>2. Select grain replacement color (an color not on the image).</HTML>");

        jButton2.setText("Select");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jLabel3.setText("<HTML>3. Select grain and adjust degree of color match </HTML>");

        jButton3.setText("Select");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jLabel5.setOpaque(true);
        jLabel5.setBackground(java.awt.Color.RED);

        jSlider1.setMajorTickSpacing(10);
        jSlider1.setPaintLabels(true);

        jProgressBar1.setStringPainted(true);

        if (toggled == false)
        jLabel6.setText(" ");
        jLabel6.setText(" ");
        jLabel6.setAutoscrolls(true);
        if (toggled == true)
        jLabel6.setText("Please select a grain");

        jTable2.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Mineral", "Color", "# of Pixels", "Percentage"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Object.class, java.lang.Integer.class, java.lang.Integer.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTable2.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setViewportView(jTable2);

        jLabel7.setText("4. Name Mineral, Add to list and repeat at Step 2.  ");

        jLabel8.setText("Name:");

        jButton4.setText("Add to list");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jScrollPane1.setAutoscrolls(true);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel4.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabel4.setAutoscrolls(true);
        jLabel4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel4MouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jLabel4);

        jMenu1.setText("File");
        jMenu1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenu1ActionPerformed(evt);
            }
        });

        jMenuItem1.setText("Exit");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem1);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("Help");
        jMenu2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenu2ActionPerformed(evt);
            }
        });

        jMenuItem2.setText("About");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        jMenu2.add(jMenuItem2);

        jMenuBar1.add(jMenu2);

        jMenu3.setText("About");

        jMenuItem3.setText("About");
        jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem3ActionPerformed(evt);
            }
        });
        jMenu3.add(jMenuItem3);

        jMenuBar1.add(jMenu3);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel5, javax.swing.GroupLayout.PREFERRED_SIZE, 37, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton1)
                            .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE)
                            .addComponent(jButton2)
                            .addComponent(jButton3)
                            .addComponent(jLabel3, 0, 0, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel7))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel8)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jButton4))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 226, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel6, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 1035, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, 56, Short.MAX_VALUE)
                        .addGap(7, 7, 7)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 440, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton2, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel5, javax.swing.GroupLayout.PREFERRED_SIZE, 8, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(3, 3, 3)
                        .addComponent(jLabel7)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel8)
                            .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jProgressBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

   /*
    * Method to draw the image
    */
    public void paintComponent(Graphics g) {
        g.drawImage(image, 0, 0, null);

    }


   public void setjLabel6(JLabel jLabel6) {
        this.jLabel6 = jLabel6;
    }

/*
 * Creating of the File Filter Guidelines to ensure
  only Image Files are opened
 */
    private final String[] okFileExtensions =
    new String[] {"jpg", "png", "gif"};

  /*
   * Method to check if the File is acceptable as an Image File
   */
    public boolean accept(File file)
  {
    for (String extension : okFileExtensions)
    {
      if (file.getName().toLowerCase().endsWith(extension))
      {
        return true;
      }
    }
    return false;
  }

// Action for the Load Image Button
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

    //Opening of the Image File
    javax.swing.JFileChooser chooser = new javax.swing.JFileChooser();
    chooser.showOpenDialog(jButton1);
    String filePath = chooser.getSelectedFile().getAbsolutePath();

    //Filtering out non-image Files
    if(!accept(chooser.getSelectedFile()))
   
        //If incorrect bring the user back to the selection screen and inform him of the error
        javax.swing.JOptionPane.showMessageDialog(null,"Not a supported file type.  The program can read .gif, .jpg, .png");
    else
    {
        /*
         * If correct use the image and display it in the jLabel4
         * Set the pictureLoaded variable to true and allow grain replacement mode 
         * also create a buffered image from the loaded image
         */
        image = Toolkit.getDefaultToolkit().getImage(filePath);
        jLabel4.setIcon(new javax.swing.ImageIcon(filePath));
        pictureLoaded = true;
        imageTemp = new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
        Graphics g = imageTemp.createGraphics();
        g.drawImage(image, 0, 0, null);
        processedPixels = new int[imageTemp.getTileWidth()][imageTemp.getTileHeight()];
        System.out.println(processedPixels.length);
    }

       
    }//GEN-LAST:event_jButton1ActionPerformed

    //old non used function which I couldn't delete in NetBeans
    private void jMenu1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenu1ActionPerformed
     
     
     
    }//GEN-LAST:event_jMenu1ActionPerformed

    //old non used function which I couldn't delete in NetBeans
    private void jMenu2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenu2ActionPerformed

 

    }//GEN-LAST:event_jMenu2ActionPerformed

    //Action for Exiting
    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed

       int returnVal = javax.swing.JOptionPane.showConfirmDialog(null, "Really want to quit?");
        if (returnVal == 0)
            System.exit(0);

    }//GEN-LAST:event_jMenuItem1ActionPerformed

    //Action to present the "About" information
    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed

        javax.swing.JOptionPane.showMessageDialog(null, "To be implemented!");
        
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    //Changing color on keypress
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

     /*
      * creating a JColorChooser and display it for choosing colors
      */
     javax.swing.JColorChooser chooser = new javax.swing.JColorChooser();
     Color newColor = chooser.showDialog(chooser, null, jLabel5.getBackground());
     rgbColor = newColor.getRGB();
     color = newColor;
     /*
      * If a color is selected change the displayed color to the chosen color
      */
     if (newColor != null)
     {
        jLabel5.setBackground(newColor);

     }

    }//GEN-LAST:event_jButton2ActionPerformed

    //code to display the About information
    private void jMenuItem3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem3ActionPerformed
         javax.swing.JOptionPane.showMessageDialog(null, "A project created by Julian Bertmaring" +
                "based on an existing Program by Kenrick Mock and Concept/Design by Jeff Amato.");
    }//GEN-LAST:event_jMenuItem3ActionPerformed


    //code to enter the grain replacement mode if the grain replacement button got pressed
    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
    if (pictureLoaded ==true)
    {
        //enter the grain replacement mode
        toggled = true;
        //display text to inform the user that the grain replacement mode is active
        //and what he should do next
        jLabel6.setText("<HTML> Please select a grain </HTML>");
    }
    }//GEN-LAST:event_jButton3ActionPerformed

    //code for handling mouseclicks on the image
    private void jLabel4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseClicked
       //if the grain replacement mode is active and a picture is loaded it does something
        if (toggled == true && pictureLoaded == true)
       {
           /*
            * variable declaration block
            */
           //x value of the mouseclick
           int x = evt.getX();
           //y value of the mouseclick
           int y = evt.getY();
           //position given out in the cmd window
           System.out.println(x);
           System.out.println(y);
           //getting the rgb value of the pixel in the clicked position
           int rgb = imageTemp.getRGB(x,y);
           //creating a new copy of the image
           BufferedImage imageTempNew = new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
           //drawing the image
           Graphics gNew = imageTempNew.createGraphics();
           gNew.drawImage(image, 0, 0, null);
           //give out the rgb value in the cmd window
           System.out.println(rgb);
           //creating progress bar
           jProgressBar1.setMaximum(100);
           //calculating the slider bars value for tolerance calculation
           int slider = jSlider1.getValue() * 100;
           int dummy = rgb;
           int difference = 0;
           int counter = 0;
           //for loops for checking the whole image for pixels of the color within tolerance
           // for loop for x coordinates
           for (int xNew = imageTemp.getMinX(); xNew < imageTemp.getTileWidth(); xNew++)
           {
               //for loop for y coordinates
               for (int yNew = imageTemp.getMinY(); yNew < imageTemp.getTileHeight(); yNew++)
               {
                       //calculating the difference of the pixels rgb and the rgb of the orginal rgb
                       // absolute value of (new pixels value) - (original pixels value)
                       difference = Math.abs(imageTemp.getRGB(xNew,yNew)) - Math.abs(rgb);

                       dummy = dummy -1;
                       //update the progress bar
                       jProgressBar1.setValue(((1-dummy)/rgb)/100);
                       jProgressBar1.setStringPainted(true);
                       //if the processed pixel wasnt already edited go on
                       if (processedPixels[xNew][yNew] != 1)
                       {
                            //if the rgb value is within tolerance
                            if (difference < slider)
                            {
                                //increase the counter by 1, paint it with the new color 
                                //and add it to the array of processed pixels
                                imageTempNew.setRGB(xNew,yNew,rgbColor);
                                counter++;
                                processedPixels[xNew][yNew] = 1;
                            }
                       }
                       
                      
               }
           }
           //after we are done we adding the value of the number of pixels to our global variable
           percentage = counter;
           //testing value gets given out to the cmd window
           System.out.println("test");
           //the image gets overwritten with the new updated image and displayed
           image = imageTempNew;
           jLabel4.setIcon(new javax.swing.ImageIcon(image));
           //leaving grain replacement mode
           toggled = false;
           //change the status text back to normal
           jLabel6.setText(" ");
       }
    }//GEN-LAST:event_jLabel4MouseClicked

    //handling of the "add to list" button
    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed

        //testing text gets printed out the cmd window
        System.out.println(jTable2.getRowCount());
        //read in the text from the texbox of the mineral name
        String mineral = jTextField1.getText();
        //calculate the total number of pixels
        overall = percentage + overall;
        int numberOfPixels = percentage;
        //add the number of pixel to an array for later use
        percentages[row]=percentage;
        //add the information of the current processed pixels to the table
        jTable2.setValueAt(mineral, row, 0);
        jTable2.setValueAt(color, row, 1);
        jTable2.setValueAt(numberOfPixels, row, 2);
        //for the percent field go through all the rows and update the information
        for (int i = 0; i <= row; i++)
        {
           //while going through the rows go and calculate the percentages of this field and add it
           jTable2.setValueAt((100*percentages[i] / overall), i, 3);
        }
        //increase the row counter for the array after you are done
        row++;
        //redraw the jTable
        jTable2.revalidate();
        //switch to the next default color
        colorIndex++;
        //when you are out of default colors go back to the first one
        if (colorIndex > suggestedColors.length)
                {
                    colorIndex = 0;
                }
        //change the displayed color value to the default color
        jLabel5.setBackground(suggestedColors[colorIndex]);
        //change all the color depending variables to reflect the new color
        rgbColor = suggestedColors[colorIndex].getRGB();
        color = suggestedColors[colorIndex];
    }//GEN-LAST:event_jButton4ActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Frame().setVisible(true);


            }

        });


    }



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JTable jTable2;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables

}
