/*
 * Decompiled with CFR 0.152.
 */
package anima;

import anima.mazeNode;
import com.sun.opengl.util.Animator;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Level4
extends JFrame
implements GLEventListener {
    GLCanvas canvas;
    JMenuBar menubar;
    JMenu file;
    JMenu texture;
    JMenuItem closer;
    JMenuItem brush;
    JMenuItem kanji;
    JMenuItem glass;
    JOptionPane option;
    JOptionPane error;
    int numLines;
    int numXLines;
    int numYLines;
    int numSqr;
    float ygap;
    float xgap;
    float ratX;
    float ratY;
    float north;
    float south;
    float east;
    float west;
    float fogDensity;
    float[] wallSpec;
    float[] ratSpec;
    float[] ratDiff;
    float[] lightPosition;
    float[] whiteLight;
    float[] ambientLight;
    float[] fogColor;
    float shininess;
    int ratFace;
    int ratCell;
    int bottomHole;
    int topHole;
    ArrayList<mazeNode> nodeList;
    int[] maze;
    int cellsInList;
    int fogSetting;
    boolean ratsEye;
    Texture currentTexture;
    Texture circuitTexture;
    Texture goldTexture;
    Texture borgTexture;
    String brushFile;
    String kanjiFile;
    String glassFile;
    String currentFile;
    TextureIO texRead;

    public Level4() {
        this.setDefaultCloseOperation(3);
        this.canvas = new GLCanvas();
        this.setUndecorated(true);
        this.setExtendedState(6);
        this.numYLines = 16;
        this.numXLines = 16;
        this.shininess = 10.0f;
        this.wallSpec = new float[4];
        this.wallSpec[0] = 0.4f;
        this.wallSpec[1] = 0.0f;
        this.wallSpec[2] = 0.4f;
        this.wallSpec[3] = 1.0f;
        this.lightPosition = new float[4];
        this.lightPosition[0] = 10.0f;
        this.lightPosition[1] = 0.0f;
        this.lightPosition[2] = 30.0f;
        this.lightPosition[3] = 1.0f;
        this.whiteLight = new float[4];
        this.whiteLight[0] = 1.0f;
        this.whiteLight[1] = 1.0f;
        this.whiteLight[2] = 1.0f;
        this.whiteLight[3] = 1.0f;
        this.ambientLight = new float[4];
        this.ambientLight[0] = 0.4f;
        this.ambientLight[1] = 0.4f;
        this.ambientLight[2] = 0.4f;
        this.ambientLight[3] = 1.0f;
        this.ratSpec = new float[4];
        this.ratSpec[0] = 0.0f;
        this.ratSpec[1] = 0.8f;
        this.ratSpec[2] = 0.0f;
        this.ratSpec[3] = 1.0f;
        this.ratDiff = new float[4];
        this.ratDiff[0] = 1.0f;
        this.ratDiff[1] = 1.0f;
        this.ratDiff[2] = 1.0f;
        this.ratDiff[3] = 1.0f;
        this.fogColor = new float[4];
        this.fogColor[0] = 0.5f;
        this.fogColor[1] = 0.5f;
        this.fogColor[2] = 0.5f;
        this.fogColor[3] = 1.0f;
        this.fogDensity = 0.0f;
        this.add(this.canvas);
        this.addKeyListener(new keyHandler(this));
        Animator animator = new Animator(this.canvas);
        this.setVisible(true);
        animator.start();
    }

    public void initMaze() {
        this.cellsInList = this.numSqr = this.numXLines * this.numYLines;
        this.xgap = 1600 / (this.numXLines + 2);
        this.ygap = 1200 / (this.numYLines + 2);
        this.bottomHole = (int)(Math.random() * (double)this.numXLines);
        this.topHole = (int)(Math.random() * (double)this.numXLines + (double)((this.numYLines - 1) * this.numXLines));
        this.maze = new int[this.numXLines * this.numYLines];
        this.ratFace = 1;
        this.ratCell = this.bottomHole;
        this.setLocationRelativeTo(null);
    }

    public void createMaze() {
        int i;
        this.initMaze();
        this.nodeList = new ArrayList();
        for (i = 0; i < this.maze.length; ++i) {
            this.maze[i] = -1;
        }
        for (i = 0; i < this.numSqr; ++i) {
            this.nodeList.add(new mazeNode(i, (float)(i % this.numXLines + 1) * this.xgap - 800.0f, (float)(i / this.numXLines + 1) * this.ygap - 600.0f));
        }
        while (this.cellsInList > 1) {
            int other = 0;
            int rand = (int)(Math.random() * (double)this.numSqr);
            int dir = (int)(Math.random() * 4.0);
            if (dir == 0) {
                other = rand % this.numXLines == this.numXLines - 1 ? rand - 1 : rand + 1;
            }
            if (dir == 1) {
                other = rand >= this.numXLines * (this.numYLines - 1) ? rand - this.numXLines : rand + this.numXLines;
            }
            if (dir == 2) {
                other = rand % this.numXLines == 0 ? rand + 1 : rand - 1;
            }
            if (dir == 3) {
                other = rand < this.numXLines ? rand + this.numXLines : rand - this.numXLines;
            }
            if (this.root(rand) == this.root(other)) continue;
            this.union(rand, other);
        }
    }

    public int root(int num) {
        if (this.maze[num] < 0) {
            return num;
        }
        return this.root(this.maze[num]);
    }

    public void union(int first, int second) {
        mazeNode base = this.nodeList.get(first);
        mazeNode mate = this.nodeList.get(second);
        base.connections.add(mate);
        mate.connections.add(base);
        this.nodeList.set(first, base);
        this.nodeList.set(second, mate);
        int root1 = this.root(first);
        int root2 = this.root(second);
        int neg = this.maze[root2];
        this.maze[root2] = root1;
        int n = root1;
        this.maze[n] = this.maze[n] + neg;
        --this.cellsInList;
    }

    public void drawMaze(GL gl, ArrayList<mazeNode> nodeList) {
        mazeNode temp = null;
        mazeNode connector = null;
        boolean left = true;
        boolean right = true;
        boolean up = true;
        boolean down = true;
        gl.glMaterialfv(1032, 4610, this.wallSpec, 0);
        gl.glMaterialfv(1032, 4609, this.whiteLight, 0);
        gl.glMaterialf(1032, 5633, this.shininess);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        temp = nodeList.get(0);
        gl.glVertex3f(temp.x, temp.y, 0.0f);
        temp = nodeList.get(this.numXLines - 1);
        gl.glVertex3f(temp.x + this.xgap, temp.y, 0.0f);
        temp = nodeList.get(nodeList.size() - 1);
        gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap, 0.0f);
        temp = nodeList.get((this.numYLines - 1) * this.numXLines);
        gl.glVertex3f(temp.x, temp.y + this.ygap, 0.0f);
        for (int i = 0; i < nodeList.size(); ++i) {
            temp = nodeList.get(i);
            if (i == this.bottomHole) {
                down = false;
            }
            if (i == this.topHole) {
                up = false;
            }
            for (int j = 0; j < temp.connections.size(); ++j) {
                connector = temp.connections.get(j);
                if (connector.name == temp.name + 1) {
                    right = false;
                }
                if (connector.name == temp.name - 1) {
                    left = false;
                }
                if (connector.name == temp.name + this.numXLines) {
                    up = false;
                }
                if (connector.name != temp.name - this.numXLines) continue;
                down = false;
            }
            if (left) {
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(-1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glNormal3f(1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glNormal3f(0.0f, -1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(0.0f, 0.0f, 1.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap / 8.0f, temp.y, 10.0f);
            }
            if (up) {
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(-1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, -1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, 0.0f, 1.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap + this.ygap / 8.0f, 10.0f);
            }
            if (right) {
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(-1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glNormal3f(1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 0.0f);
                gl.glNormal3f(0.0f, -1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 0.0f);
                gl.glNormal3f(0.0f, 0.0f, 1.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y, 10.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap - this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y + this.ygap, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap + this.xgap / 8.0f, temp.y, 10.0f);
            }
            if (down) {
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(-1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(1.0f, 0.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, 1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, -1.0f, 0.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 0.0f);
                gl.glNormal3f(0.0f, 0.0f, 1.0f);
                gl.glTexCoord2f(this.west, this.north);
                gl.glVertex3f(temp.x, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.north);
                gl.glVertex3f(temp.x + this.xgap, temp.y - this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.east, this.south);
                gl.glVertex3f(temp.x + this.xgap, temp.y + this.ygap / 8.0f, 10.0f);
                gl.glTexCoord2f(this.west, this.south);
                gl.glVertex3f(temp.x, temp.y + this.ygap / 8.0f, 10.0f);
            }
            left = true;
            right = true;
            up = true;
            down = true;
        }
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glShadeModel(7425);
        this.fogSetting = 2048;
        this.texRead = new TextureIO();
        this.brushFile = "trial.jpg";
        this.glassFile = "trial2.gif";
        this.kanjiFile = "trial3.jpg";
        try {
            this.borgTexture = TextureIO.newTexture(this.getClass().getResource(this.kanjiFile), false, ".jpg");
            this.borgTexture.setTexParameteri(10242, 33071);
            this.borgTexture.setTexParameteri(10243, 33071);
            this.borgTexture.setTexParameteri(10240, 9728);
            this.borgTexture.setTexParameteri(10241, 9728);
            this.goldTexture = TextureIO.newTexture(this.getClass().getResource(this.glassFile), false, ".gif");
            this.goldTexture.setTexParameteri(10242, 33071);
            this.goldTexture.setTexParameteri(10243, 33071);
            this.goldTexture.setTexParameteri(10240, 9728);
            this.goldTexture.setTexParameteri(10241, 9728);
            this.circuitTexture = TextureIO.newTexture(this.getClass().getResource(this.brushFile), false, ".jpg");
            this.circuitTexture.setTexParameteri(10242, 33071);
            this.circuitTexture.setTexParameteri(10243, 33071);
            this.circuitTexture.setTexParameteri(10240, 9728);
            this.circuitTexture.setTexParameteri(10241, 9728);
        }
        catch (Exception e) {
            System.err.println("Error generating texture");
            System.err.println("Exception is: " + e);
        }
        this.currentTexture = this.borgTexture;
        gl.glEnable(2896);
        gl.glEnable(16384);
        gl.glEnable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, this.canvas.getWidth(), 0.0, this.canvas.getHeight(), -10.0, 10.0);
        gl.glMatrixMode(5888);
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (width <= height) {
            gl.glOrtho(-600.0, 600.0, -600.0 * (double)((float)height / (float)width), 600.0 * (double)height / (double)width, -1000.0, 1000.0);
        } else {
            gl.glOrtho(-600.0 * (double)((float)width / (float)height), 600.0 * (double)width / (double)height, -600.0, 600.0, -1000.0, 1000.0);
        }
        gl.glMatrixMode(5888);
    }

    public void look(GLU glu, GL gl) {
        if (this.ratFace == 0) {
            gl.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            glu.gluLookAt(this.ratX, this.ratY + this.ygap / 6.0f, 5.0, this.ratX + 5.0f, this.ratY + this.ygap / 6.0f, -1.0, 0.0, 1.0, 0.0);
        }
        if (this.ratFace == 1) {
            glu.gluLookAt(this.ratX + this.xgap / 6.0f, this.ratY, 5.0, this.ratX + this.xgap / 6.0f, this.ratY + 5.0f, -1.0, 0.0, 1.0, 0.0);
        }
        if (this.ratFace == 2) {
            gl.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
            glu.gluLookAt(this.ratX, this.ratY + this.ygap / 6.0f, 5.0, this.ratX - 5.0f, this.ratY + this.ygap / 6.0f, -1.0, 0.0, 1.0, 0.0);
        }
        if (this.ratFace == 3) {
            gl.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            glu.gluLookAt(this.ratX + this.xgap / 6.0f, this.ratY, 5.0, this.ratX + this.xgap / 6.0f, this.ratY - 5.0f, -1.0, 0.0, 1.0, 0.0);
        }
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        gl.glClear(16640);
        gl.glLoadIdentity();
        gl.glEnable(2848);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glLightfv(16384, 4611, this.lightPosition, 0);
        gl.glLightfv(16384, 4609, this.whiteLight, 0);
        gl.glLightfv(16384, 4610, this.whiteLight, 0);
        gl.glLightModelfv(2899, this.ambientLight, 0);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluPerspective(120.0, 4.0, 1.0, 1000.0);
        this.look(glu, gl);
        gl.glMatrixMode(5888);
        this.ratX = this.nodeList.get((int)this.ratCell).x + this.xgap / 3.0f;
        this.ratY = this.nodeList.get((int)this.ratCell).y + this.ygap / 3.0f;
        this.currentTexture.setTexParameteri(10242, 33071);
        this.currentTexture.setTexParameteri(10243, 33071);
        this.currentTexture.setTexParameteri(10240, 9728);
        this.currentTexture.setTexParameteri(10241, 9728);
        TextureCoords coords = this.currentTexture.getImageTexCoords();
        this.west = coords.left();
        this.north = coords.top();
        this.east = coords.right();
        this.south = coords.bottom();
        this.currentTexture.bind();
        this.currentTexture.enable();
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glBegin(7);
        gl.glColor3f(0.3f, 0.3f, 1.0f);
        this.drawMaze(gl, this.nodeList);
        gl.glEnd();
        gl.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
        gl.glFogi(2917, this.fogSetting);
        gl.glFogfv(2918, this.fogColor, 0);
        gl.glFogf(2914, this.fogDensity);
        gl.glHint(3156, 4352);
        gl.glFogf(2915, 1.0f);
        gl.glFogf(2916, 50.0f);
        gl.glEnable(2912);
        gl.glFlush();
        gl.glDisable(3553);
    }

    @Override
    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    class keyHandler
    implements KeyListener {
        Level4 maze;

        public keyHandler(Level4 m) {
            this.maze = m;
        }

        public void keyReleased(KeyEvent e) {
        }

        public void move(KeyEvent e, mazeNode connectNode, mazeNode node) {
            for (int i = 0; i < node.connections.size(); ++i) {
                connectNode = node.connections.get(i);
                if (Level4.this.ratFace == 2 && connectNode.name == Level4.this.ratCell - 1) {
                    --Level4.this.ratCell;
                    continue;
                }
                if (Level4.this.ratFace == 0 && connectNode.name == Level4.this.ratCell + 1) {
                    ++Level4.this.ratCell;
                    continue;
                }
                if (Level4.this.ratFace == 1 && Level4.this.ratCell == Level4.this.topHole) {
                    Level4.this.currentTexture = Level4.this.goldTexture;
                    continue;
                }
                if (Level4.this.ratFace == 1 && connectNode.name == Level4.this.ratCell + Level4.this.numXLines) {
                    Level4.this.ratCell += Level4.this.numXLines;
                    continue;
                }
                if (Level4.this.ratFace != 3 || connectNode.name != Level4.this.ratCell - Level4.this.numXLines) continue;
                Level4.this.ratCell -= Level4.this.numXLines;
            }
        }

        public void keyPressed(KeyEvent e) {
            mazeNode node = Level4.this.nodeList.get(Level4.this.ratCell);
            mazeNode connectNode = null;
            if (e.getKeyCode() == 37) {
                Level4.this.ratFace = Level4.this.ratFace < 3 ? ++Level4.this.ratFace : 0;
            }
            if (e.getKeyCode() == 39) {
                Level4.this.ratFace = Level4.this.ratFace > 0 ? --Level4.this.ratFace : 3;
            }
            if (e.getKeyCode() == 38) {
                this.move(e, connectNode, node);
            }
            if (e.getKeyCode() == 40) {
                Level4.this.ratFace = 3;
            }
            if (e.getKeyCode() == 82) {
                Level4.this.ratsEye = true;
                Level4.this.fogDensity = 0.2f;
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class innerHandler
    implements ActionListener {
        innerHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == Level4.this.closer) {
                System.exit(0);
            }
            if (e.getSource() == Level4.this.brush) {
                Level4.this.currentTexture = Level4.this.circuitTexture;
            }
            if (e.getSource() == Level4.this.kanji) {
                Level4.this.currentTexture = Level4.this.borgTexture;
            }
            if (e.getSource() == Level4.this.glass) {
                Level4.this.currentTexture = Level4.this.goldTexture;
            }
        }
    }
}

