/*
 * Decompiled with CFR 0.152.
 */
package btclientalpha;

import btclientalpha.Hex;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

public class GameCanvas
extends Canvas {
    Hex[][] h1;
    int hexSize;
    int hexX;
    int hexY;
    int h;
    int v;
    int[] xPoints;
    int[] yPoints;
    int mechX;
    int mechY;
    int mechDirection;

    public GameCanvas(int sizeIn, int hexXIn, int hexYIn) {
        this.hexSize = sizeIn;
        this.hexX = hexXIn;
        this.hexY = hexYIn;
        this.h1 = new Hex[this.hexX][this.hexY];
        Hex template = new Hex(0, 0, this.hexSize);
        this.h = template.getHorzOffset();
        this.v = template.getYVertsAT(0)[0];
        int lx = 0;
        int ly = 0;
        for (int i = 0; i < this.hexX; ++i) {
            ly = i % 2 == 1 ? this.v : 0;
            for (int j = 0; j < this.hexY; ++j) {
                this.h1[i][j] = new Hex(lx, ly, this.hexSize);
                ly += 2 * this.v;
            }
            lx += this.h;
        }
        this.mechX = 0;
        this.mechY = 0;
        this.mechDirection = 2;
    }

    public void mechTurnLeft() {
        this.mechDirection = this.mechDirection == 0 ? 5 : --this.mechDirection;
    }

    public void mechTurnRight() {
        this.mechDirection = this.mechDirection == 5 ? 0 : ++this.mechDirection;
    }

    public void mechForward() {
        switch (this.mechDirection) {
            case 0: {
                if (this.mechY == 0) break;
                --this.mechY;
                break;
            }
            case 1: {
                if (this.mechY != 0 && this.mechX != this.hexX - 1) {
                    if (this.mechX % 2 == 0) {
                        ++this.mechX;
                        --this.mechY;
                        break;
                    }
                    ++this.mechX;
                    break;
                }
                if (this.mechY != 0 || this.mechX == this.hexX - 1 || this.mechX % 2 != 1) break;
                ++this.mechX;
                break;
            }
            case 2: {
                if (this.mechX == this.hexX - 1 || this.mechY == this.hexY - 1) break;
                if (this.mechX % 2 == 0) {
                    ++this.mechX;
                    break;
                }
                ++this.mechX;
                ++this.mechY;
                break;
            }
            case 3: {
                if (this.mechY == this.hexY - 1) break;
                ++this.mechY;
                break;
            }
            case 4: {
                if (this.mechX == 0 || this.mechY == this.hexY - 1) break;
                if (this.mechX % 2 == 0) {
                    --this.mechX;
                    break;
                }
                --this.mechX;
                ++this.mechY;
                break;
            }
            case 5: {
                if (this.mechY != 0 && this.mechX != 0) {
                    if (this.mechX % 2 == 0) {
                        --this.mechX;
                        --this.mechY;
                        break;
                    }
                    --this.mechX;
                    break;
                }
                if (this.mechY != 0 || this.mechX % 2 != 1) break;
                --this.mechX;
            }
        }
    }

    public void mechBackward() {
        switch (this.mechDirection) {
            case 0: {
                if (this.mechY == this.hexY - 1) break;
                ++this.mechY;
                break;
            }
            case 1: {
                if (this.mechY != this.hexY - 1 && this.mechX != 0) {
                    if (this.mechX % 2 == 1) {
                        --this.mechX;
                        ++this.mechY;
                        break;
                    }
                    --this.mechX;
                    break;
                }
                if (this.mechY != 0 || this.mechX % 2 != 1) break;
                --this.mechX;
                break;
            }
            case 2: {
                if (this.mechX == 0 || this.mechY == 0) break;
                if (this.mechX % 2 == 1) {
                    --this.mechX;
                    break;
                }
                --this.mechX;
                --this.mechY;
                break;
            }
            case 3: {
                if (this.mechY == 0) break;
                --this.mechY;
                break;
            }
            case 4: {
                if (this.mechX == this.hexX - 1) break;
                if (this.mechX % 2 == 1) {
                    ++this.mechX;
                    break;
                }
                ++this.mechX;
                --this.mechY;
                break;
            }
            case 5: {
                if (this.mechY != this.hexY - 1 && this.mechX != this.hexX - 1) {
                    if (this.mechX % 2 == 1) {
                        ++this.mechX;
                        ++this.mechY;
                        break;
                    }
                    ++this.mechX;
                    break;
                }
                if (this.mechY != this.hexY - 1 || this.mechX % 2 != 1) break;
                ++this.mechX;
            }
        }
    }

    public void updateSize(int sizeIn) {
        this.hexSize = sizeIn;
        this.h1[0][0] = new Hex(0, 0, this.hexSize);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawHexGrid(g);
        this.drawMech(g);
    }

    private void drawMech(Graphics g) {
        int[] mx = new int[]{10, 30, 20, 10};
        int[] my = new int[]{0, 0, 30, 0};
        this.xPoints = this.h1[this.mechX][this.mechY].getXVertsAT(this.h1[this.mechX][this.mechY].getX());
        this.yPoints = this.h1[this.mechX][this.mechY].getYVertsAT(this.h1[this.mechX][this.mechY].getY());
        switch (this.mechDirection) {
            case 0: {
                mx[0] = this.xPoints[4];
                my[0] = this.yPoints[4];
                mx[1] = this.xPoints[5];
                my[1] = this.yPoints[5];
                mx[2] = this.xPoints[1] + (this.xPoints[2] - this.xPoints[1]) / 2;
                my[2] = this.yPoints[2];
                mx[3] = mx[0];
                my[3] = my[0];
                break;
            }
            case 1: {
                mx[0] = this.xPoints[5];
                my[0] = this.yPoints[5];
                mx[1] = this.xPoints[6];
                my[1] = this.yPoints[6];
                mx[2] = this.xPoints[2] + (this.xPoints[3] - this.xPoints[2]) / 2;
                my[2] = this.yPoints[2] - (this.yPoints[2] - this.yPoints[3]) / 2;
                mx[3] = mx[0];
                my[3] = my[0];
                break;
            }
            case 2: {
                mx[0] = this.xPoints[0];
                my[0] = this.yPoints[0];
                mx[1] = this.xPoints[1];
                my[1] = this.yPoints[1];
                mx[2] = this.xPoints[4] + (this.xPoints[3] - this.xPoints[2]) / 2;
                my[2] = this.yPoints[4] + (this.xPoints[4] - this.xPoints[3]) / 2;
                mx[3] = mx[0];
                my[3] = my[0];
                break;
            }
            case 3: {
                mx[0] = this.xPoints[1];
                my[0] = this.yPoints[1];
                mx[1] = this.xPoints[2];
                my[1] = this.yPoints[2];
                mx[2] = this.xPoints[5] + (this.xPoints[4] - this.xPoints[5]) / 2;
                my[2] = this.yPoints[4];
                mx[3] = mx[0];
                my[3] = my[0];
                break;
            }
            case 4: {
                mx[0] = this.xPoints[2];
                my[0] = this.yPoints[2];
                mx[1] = this.xPoints[3];
                my[1] = this.yPoints[3];
                mx[2] = this.xPoints[5] - (this.xPoints[5] - this.xPoints[6]) / 2;
                my[2] = this.yPoints[5] - (this.xPoints[5] - this.xPoints[6]) / 2;
                mx[3] = mx[0];
                my[3] = my[0];
                break;
            }
            case 5: {
                mx[0] = this.xPoints[3];
                my[0] = this.yPoints[3];
                mx[1] = this.xPoints[4];
                my[1] = this.yPoints[4];
                mx[2] = this.xPoints[0] + (this.xPoints[1] - this.xPoints[0]) / 2;
                my[2] = this.yPoints[0] + (this.xPoints[0] - this.xPoints[1]) / 2;
                mx[3] = mx[0];
                my[3] = my[0];
            }
        }
        g.setColor(Color.RED);
        g.fillPolygon(mx, my, 4);
    }

    private void drawHexGrid(Graphics g) {
        for (int i = 0; i < this.hexX; ++i) {
            for (int j = 0; j < this.hexY; ++j) {
                this.xPoints = this.h1[i][j].getXVertsAT(this.h1[i][j].getX());
                this.yPoints = this.h1[i][j].getYVertsAT(this.h1[i][j].getY());
                g.drawPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                g.drawString(Integer.toString(this.h1[i][j].getTerrain()), this.xPoints[0] + 10, this.yPoints[0] + 10);
            }
        }
    }
}

