/*
 * Decompiled with CFR 0.152.
 */
package btclientalpha;

import java.util.Random;

public class Hex {
    private int x;
    private int y;
    private double a;
    private double b;
    private double c;
    private double sin60 = Math.sin(Math.toRadians(60.0));
    private double[][] verts;
    private int terrain;
    Random gen;

    public Hex(int xIn, int yIn, int sideLength) {
        this.c = sideLength;
        this.b = this.sin60 * this.c;
        this.a = this.c / 2.0;
        this.x = xIn;
        this.y = yIn;
        this.verts = new double[7][2];
        this.verts[0][0] = 0.0;
        this.verts[0][1] = this.b;
        this.verts[1][0] = this.a;
        this.verts[1][1] = 0.0;
        this.verts[2][0] = this.a + this.c;
        this.verts[2][1] = 0.0;
        this.verts[3][0] = 2.0 * this.c;
        this.verts[3][1] = this.b;
        this.verts[4][0] = this.a + this.c;
        this.verts[4][1] = 2.0 * this.b;
        this.verts[5][0] = this.a;
        this.verts[5][1] = 2.0 * this.b;
        this.verts[6][0] = 0.0;
        this.verts[6][1] = this.b;
        this.gen = new Random();
        this.terrain = this.gen.nextInt(10);
    }

    public int[][] getVerts() {
        int[][] temp = new int[7][2];
        temp[0][0] = (int)Math.round(this.verts[0][0] + (double)this.x);
        temp[0][1] = (int)Math.round(this.verts[0][1] + (double)this.y);
        temp[1][0] = (int)Math.round(this.verts[1][0] + (double)this.x);
        temp[1][1] = (int)Math.round(this.verts[1][1] + (double)this.y);
        temp[2][0] = (int)Math.round(this.verts[2][0] + (double)this.x);
        temp[2][1] = (int)Math.round(this.verts[2][1] + (double)this.y);
        temp[3][0] = (int)Math.round(this.verts[3][0] + (double)this.x);
        temp[3][1] = (int)Math.round(this.verts[3][1] + (double)this.y);
        temp[4][0] = (int)Math.round(this.verts[4][0] + (double)this.x);
        temp[4][1] = (int)Math.round(this.verts[4][1] + (double)this.y);
        temp[5][0] = (int)Math.round(this.verts[5][0] + (double)this.x);
        temp[5][1] = (int)Math.round(this.verts[5][1] + (double)this.y);
        temp[6][0] = (int)Math.round(this.verts[6][0] + (double)this.x);
        temp[6][1] = (int)Math.round(this.verts[6][1] + (double)this.y);
        return temp;
    }

    public int getTerrain() {
        return this.terrain;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int[] getXVertsAT(int xIn) {
        int[] temp = new int[]{(int)Math.round(this.verts[0][0] + (double)xIn), (int)Math.round(this.verts[1][0] + (double)xIn), (int)Math.round(this.verts[2][0] + (double)xIn), (int)Math.round(this.verts[3][0] + (double)xIn), (int)Math.round(this.verts[4][0] + (double)xIn), (int)Math.round(this.verts[5][0] + (double)xIn), (int)Math.round(this.verts[6][0] + (double)xIn)};
        return temp;
    }

    public int[] getYVertsAT(int yIn) {
        int[] temp = new int[]{(int)Math.round(this.verts[0][1] + (double)yIn), (int)Math.round(this.verts[1][1] + (double)yIn), (int)Math.round(this.verts[2][1] + (double)yIn), (int)Math.round(this.verts[3][1] + (double)yIn), (int)Math.round(this.verts[4][1] + (double)yIn), (int)Math.round(this.verts[5][1] + (double)yIn), (int)Math.round(this.verts[6][1] + (double)yIn)};
        return temp;
    }

    public static void main(String[] args) {
        Hex h = new Hex(0, 0, 50);
        System.out.println(h.sin60);
        System.out.println("a: " + h.a + " b: " + h.b + " c: " + h.c);
        for (int i = 0; i < 7; ++i) {
            System.out.println("vertex " + (i + 1) + " x: " + h.verts[i][0] + " y: " + h.verts[i][1]);
        }
        int[][] temp = h.getVerts();
        for (int i = 0; i < 7; ++i) {
            System.out.println("vertex " + (i + 1) + " x: " + temp[i][0] + " y: " + temp[i][1]);
        }
    }

    int getHorzOffset() {
        return (int)(this.a + this.c);
    }

    int getVertOffset() {
        return (int)this.b;
    }
}

