package btclientalpha;

/*
 * DieGenerator class for Battletech TableTop game engine.
 * Usage is the constructor, and the one get method.
 * Construction is overloaded to allow a random seed value.
 *
 */
import java.util.Random;
/**
 *
 * @author Steven
 */
public class DieGenerator {

    private Random generator;

    public DieGenerator()
    {
        generator = new Random(System.currentTimeMillis()); //default generator construction
    }

    public DieGenerator(long seed) //send a seed value if required for generator randomness
    {
        generator = new Random(seed);
    }

    public int rollDie(int input)
    {
        int temp;
        if(input == 1)
            temp = generator.nextInt(6) + 1;
        else
            temp = ((generator.nextInt(6)+1) + (generator.nextInt(6)+1));
        return temp; //We return a value between 2 and 12, simulating two six-sided dice.

    }
}
