/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package btclientalpha;
import java.util.Random;


/**
 *
 * @author Steven
 */
public class Hex{

    private int x, y;
    private double a, b, c, sin60;
    private double[][] verts;
    private int terrain;
    Random gen;
    public Hex(int xIn, int yIn, int sideLength)
    {
        sin60 = Math.sin(Math.toRadians(60));

        c = sideLength;
        b = sin60 * c;
        a = c/2;
        x = xIn;
        y = yIn;

        verts = new double[7][2]; //x,y values... could be better implementation

        verts[0][0] = 0;
        verts[0][1] = b;
        verts[1][0] = a;
        verts[1][1] = 0;
        verts[2][0] = a+c;
        verts[2][1] = 0;
        verts[3][0] = 2*c;
        verts[3][1] = b;
        verts[4][0] = a+c;
        verts[4][1] = 2*b;
        verts[5][0] = a;
        verts[5][1] = 2*b;
        verts[6][0] = 0;
        verts[6][1] = b;

        gen = new Random();

        terrain = gen.nextInt(10);

    }

    public int[][] getVerts()
    {
        int[][] temp = new int[7][2];

        temp[0][0] = (int) Math.round(verts[0][0] + x);
        temp[0][1] = (int) Math.round(verts[0][1] + y);
        temp[1][0] = (int) Math.round(verts[1][0] + x);
        temp[1][1] = (int) Math.round(verts[1][1] + y);
        temp[2][0] = (int) Math.round(verts[2][0] + x);
        temp[2][1] = (int) Math.round(verts[2][1] + y);
        temp[3][0] = (int) Math.round(verts[3][0] + x);
        temp[3][1] = (int) Math.round(verts[3][1] + y);
        temp[4][0] = (int) Math.round(verts[4][0] + x);
        temp[4][1] = (int) Math.round(verts[4][1] + y);
        temp[5][0] = (int) Math.round(verts[5][0] + x);
        temp[5][1] = (int) Math.round(verts[5][1] + y);
        temp[6][0] = (int) Math.round(verts[6][0] + x);
        temp[6][1] = (int) Math.round(verts[6][1] + y);

        return temp;
    }

    public int getTerrain()
    {
        return terrain;
    }

    public int getX()
    {
        return x;
    }

    public int getY()
    {
        return y;
    }

    public int[] getXVertsAT(int xIn)
    {
        int[] temp = new int[7];

        temp[0] = (int) Math.round(verts[0][0] + xIn);
        temp[1] = (int) Math.round(verts[1][0] + xIn);
        temp[2] = (int) Math.round(verts[2][0] + xIn);
        temp[3] = (int) Math.round(verts[3][0] + xIn);
        temp[4] = (int) Math.round(verts[4][0] + xIn);
        temp[5] = (int) Math.round(verts[5][0] + xIn);
        temp[6] = (int) Math.round(verts[6][0] + xIn);

        return temp;
    }

    public int[] getYVertsAT(int yIn)
    {
          int[] temp = new int[7];

        temp[0] = (int) Math.round(verts[0][1] + yIn);
        temp[1] = (int) Math.round(verts[1][1] + yIn);
        temp[2] = (int) Math.round(verts[2][1] + yIn);
        temp[3] = (int) Math.round(verts[3][1] + yIn);
        temp[4] = (int) Math.round(verts[4][1] + yIn);
        temp[5] = (int) Math.round(verts[5][1] + yIn);
        temp[6] = (int) Math.round(verts[6][1] + yIn);

        return temp;

    }
    public static void main(String[] args)
    {
        Hex h = new Hex(0, 0, 50);
        System.out.println(h.sin60);
        System.out.println("a: " + h.a + " b: " + h.b + " c: " + h.c);

        for(int i = 0; i<7; i++)
            System.out.println("vertex " + (i+1) + " x: " + h.verts[i][0] + " y: " + h.verts[i][1]);

        int[][] temp = h.getVerts();

        for(int i = 0; i<7; i++)
            System.out.println("vertex " + (i+1) + " x: " + temp[i][0] + " y: " + temp[i][1]);

    }


    int getHorzOffset() {
        return (int)(a+c);
    }

    int getVertOffset() {
        return (int) b;
    }

}
