/*
 * This class should allow for a defined mech build out, as well as correctly setting
 * values for internal components as they are instantiated.
 *
 *  Extend off of this for pre-built configurations.
 *
 *
 */

package btclientalpha.mech;

import btclientalpha.mech.parts.Part;
import btclientalpha.mech.weapons.*;


/**
 *
 * @author Steven
 */
public class MechBody {

    //define the critical slots for equipment and weapons as object...

    //define the armored locations 
    int armorHead;
    int armorLeftLeg;
    int armorLeftArm;
    int armorLeftTorso;
    int armorLeftRearTorso;
    int armorCenterTorso;
    int armorCenterRearTorso;
    int armorRightTorso;
    int armorRightRearTorso;
    int armorRightArm;
    int armorRightLeg;

    InnerStructure is;

    int tonnage; //this is the overall weight
    double buildTonnage; //define current weight as mech is in construction process
    int walkingSpeed; //this is defined in hexes on the board, but is equivalent to 10.75KMH per unit

    int heatLevel; //keep tabs during movement, weapons, and physical phases
    HeatScale hs; //rectify during heat phase
    int pilotingSkill, gunnerySkill;
    int torsoDirection; // 0 is straight, -1 is left, 1 is right

    String mechName;

    Weapon[] weaponList; //I think I shall default to a maximum of 12 weapons for now.

    public MechBody(int tonnageIn, int walkingSpeedIn)
    {
        tonnage = tonnageIn;
        walkingSpeed = walkingSpeedIn;
 
        is = new InnerStructure(tonnage, (tonnage * walkingSpeed)); //send values for componants
        hs = new HeatScale();
        heatLevel = 0;
        pilotingSkill = 5; //this is the base number for a successful movement check
        gunnerySkill = 4; //this is the base number for a succesful weapons fire check

        torsoDirection = 0;

        mechName = "Unassigned";
        buildTonnage = getBuildTonnage();

        //weaponList = new Weapon[12];
    }

    public void setName(String nameIn)
    {
        mechName = nameIn;
    }

    public String getMechName()
    {
        return mechName;
    }

    
    public int getPilotingRoll() //must build in modifier check...
    {
        return pilotingSkill;
    }

    public int getGunneryRoll() //must build in modifier check...
    {
        return gunnerySkill + hs.getFireMod();
    }

    public int getWalkingSpeed()
    {
        int temp = walkingSpeed + getMovementMod();
        
        if(temp < 0)
            return 0;
        else
            return temp;

    }

    public int getRunningSpeed()
    {
        return (int) (getWalkingSpeed() * 1.5);
    }

    public int getMovementMod()
    {
        return hs.getMoveMod() + partsMoveMod();
    }

    public void torsoTwistLeft()
    {
        torsoDirection = -1;
    }

    public void torsoTwistRight()
    {
        torsoDirection = 1;
    }

    public void torsoTwistCenter()
    {
        torsoDirection = 0;
    }
    
    public int getTorsoDirection()
    {
        return torsoDirection;
    }

    public void addHeat(int heatIn)
    {
        heatLevel = heatLevel + heatIn;
    }

    public void heatPhase()
    {
        heatLevel = heatLevel - 10; //default number of heatsinks that dissapate 
        hs.addHeat(heatLevel);
        heatLevel = 0;
    }

    public Part partAt(int loc, int critical)
    {
        if(is.isPart(loc, critical))
            return is.partAt(loc, critical);
        else
            return null;
    }

    public void setArmor()
    {
        armorHead = 0;
        armorLeftLeg = 0;
        armorLeftArm = 0;
        armorLeftTorso = 0;
        armorLeftRearTorso = 0;
        armorCenterTorso = 0;
        armorCenterRearTorso = 0;
        armorRightTorso = 0;
        armorRightRearTorso = 0;
        armorRightArm = 0;
        armorRightLeg = 0;
    }

        public void setArmor(int[] armorIn)
    {
            if(armorIn.length == 11)
            {
                armorHead = armorIn[0];
                armorLeftLeg = armorIn[1];
                armorLeftArm = armorIn[2];
                armorLeftTorso = armorIn[3];
                armorLeftRearTorso = armorIn[4];
                armorCenterTorso = armorIn[5];
                armorCenterRearTorso = armorIn[6];
                armorRightTorso = armorIn[7];
                armorRightRearTorso = armorIn[8];
                armorRightArm = armorIn[9];
                armorRightLeg = armorIn[10];
            }
            else
                setArmor();

        int armorCount = 0;
            for(int i=0; i<armorIn.length; i++)
                armorCount = armorCount + armorIn[i];

        buildTonnage = buildTonnage + (armorCount / 16);

     }

        public int[] getArmorValues()
        {
            int temp[] = new int[11];
            temp[0] = armorHead;
            temp[1] = armorLeftLeg;
            temp[2] = armorLeftArm;
            temp[3] = armorLeftTorso;
            temp[4] = armorLeftRearTorso;
            temp[5] = armorCenterTorso;
            temp[6] = armorCenterRearTorso;
            temp[7] = armorRightTorso;
            temp[8] = armorRightRearTorso;
            temp[9] = armorRightArm;
            temp[10] = armorRightLeg;
            
            return temp;
            
        }

    private double getBuildTonnage() //This is pre armor and weapon placement. Those functions will add as required.
    {
        buildTonnage = is.engine.getTonnage();
        buildTonnage = buildTonnage + is.gyro.getTonnage();
        buildTonnage = buildTonnage + is.cockpit.getTonnage();
        buildTonnage = buildTonnage + is.getTonnage();

        
        return buildTonnage;
    }

        public double currentBuildTonnage()
        {
            return buildTonnage;
        }

    public int getHeat()
    {
        return hs.getHeatLevel();
    }

    public int getBuiltHeat()
    {
        return heatLevel;
    }
    public Weapon[] getWeapons()
    {
        return weaponList;
    }


    public static void main(String[] args) //simple test routine for method verifications...
    {
        //MechBody mb = new MechBody(20, 8);//tonnage, walking speed
        
        MechBody mb = new MechLocust();
        System.out.println("built");

        System.out.println("Running speed: " + mb.getRunningSpeed());
        System.out.println("left Leg: " + mb.is.getLeftLegArmor());

        System.out.println("Heat level: " + mb.hs.getHeatLevel());
        System.out.println("Move mod: " + mb.hs.getMoveMod());
        System.out.println("Fire mod: " + mb.hs.getFireMod());
        System.out.println("Roll for Shutdown: " + mb.hs.checkShutdown() + "\nRoll for ammo Explosion:" + mb.hs.checkAmmoExplosion());
        System.out.println("Walk: " + mb.getWalkingSpeed() + " Gunnery: " + mb.getGunneryRoll());

        System.out.println("Running speed: " + mb.getRunningSpeed());

        System.out.println("adding 25 heat...");
        
        mb.hs.addHeat(25);
        
        System.out.println("Heat level: " + mb.hs.getHeatLevel());
        System.out.println("Move mod: " + mb.hs.getMoveMod());
        System.out.println("Fire mod: " + mb.hs.getFireMod());
        System.out.println("Roll for Shutdown: " + mb.hs.checkShutdown() + "\nRoll for ammo Explosion:" + mb.hs.checkAmmoExplosion());
        System.out.println("Walk: " + mb.getWalkingSpeed() + " Gunnery: " + mb.getGunneryRoll());

        System.out.println("Running speed: " + mb.getRunningSpeed());

        if(mb.is.setPart(new WeaponLaserSmall(), 0))
            System.out.println("Small Laser Placed");

        for(int j = 0; j<8; j++)
        {
            for(int i = 0; i<12; i++)
            {
                if(i==6)
                    if(j==0 || j==1 || j==7)
                        break;

                Part temp = mb.partAt(j, i);

                if(temp != null)
                    System.out.println("Part at: " + j + ", " + i + ": " + temp.getName() + " : " +  temp.getClass());
                else
                    System.out.println("Null at: " + j + ", " + i);
            }

        }

    }

    private int partsMoveMod()
    {
        int partsMod = 0;

        for(int j = 0; j<8; j++)
        {
            for(int i = 0; i<12; i++)
            {
                if(i==6)
                    if(j==0 || j==1 || j==7)
                        break;

                Part temp = partAt(j, i);

                if(temp != null)
                    partsMod = partsMod - temp.getMoveMod();
            }

        }

        return partsMod;

    }


    
}
