/*
 * This is a base level class for all the other parts. This will define the accessor methods
 * that all the parts and weapons will utilize. I am defining the variables as
 * if they are static, but each part will set the final value.
 */

package btclientalpha.mech.parts;

/**
 *
 * @author Steven
 */
public class Part {

    double TONNAGE;
    int CRITICAL;
    int MOVEMOD;
    int FIREMOD;
    int DAMAGELEVEL;

    String NAME;
    String NICKNAME;
    String TECH;

    boolean DESTROYED;

    int COST;

    public Part()
    {
        TONNAGE = 0;
        CRITICAL = 0;
        MOVEMOD = 0;
        FIREMOD = 0;
        DAMAGELEVEL = 0;
        
        NAME = "Undefined";
        NICKNAME = "UDF";
        TECH = "UDF";
        
        DESTROYED = false;
        
        COST = 0;
    }
    
    public double getTonnage()
    {
        return TONNAGE;
    }

    public int getCritical()
    {
        return CRITICAL;
    }

    public int getMoveMod()
    {
        return MOVEMOD;
    }

    public int getFireMod()
    {
        return FIREMOD;
    }

    public int getDamageLevel()
    {
        return DAMAGELEVEL;
    }
    
    public String getName()
    {
        return NAME;
    }

    public String getNick()
    {
        return NICKNAME;
    }
    
    public String getTech()
    {
        return TECH;
    }

    public boolean isDestroyed()
    {
        return DESTROYED;
    }

    public void setDestroyed()
    {
        DESTROYED = true;
    }

    public int getCost()
    {
        return COST;
    }

}

