/*
 * This is a Weapon master class that defines the attributes of all the weapons.
 * Extending this class for each implementation is the goal.
 * Default accessor methods are pre-defined, yet some will need overwriting. 
 * and open the template in the editor.
 *
 * TYPE
 * 1 - Energy Weapon
 * 2 - Ballistic
 * 3 - Missile
 * 4 - undefined
 * 
 */


package btclientalpha.mech.weapons;

import btclientalpha.mech.parts.Part;

/**
 *
 * @author Steven
 */
public class Weapon extends Part{

    int TYPE;
    int HEAT;
    int DAMAGE;
    int MINIMUM;
    int SHORT;
    int MEDIUM;
    int LONG;
    double TONNAGE;
    int CRITICAL;
    int AMMO;

    String NAME;
    String NICKNAME;
    String TECH;

    boolean DESTROYED;

    int COST;

    public int getType()
    {
        return TYPE;
    }

    public int getHeat()
    {
        return HEAT;
    }

    public int getDamage()
    {
        return DAMAGE;
    }

    public boolean isMinimum(int rangeIn)
    {
        if(rangeIn <= MINIMUM)
           return true;
        else
           return false;
    }

    public boolean isShort(int rangeIn)
    {
         if(rangeIn <= SHORT)
           return true;
        else
           return false;

    }

    public boolean isMedium(int rangeIn)
    {
         if(rangeIn <= MEDIUM)
           return true;
        else
           return false;

    }

    public boolean isLong(int rangeIn)
    {
         if(rangeIn <= LONG)
           return true;
        else
           return false;

    }

    public int getRange()
    {
        return LONG;
    }

    public double getTonnage()
    {
        return TONNAGE;
    }

    public int getCritical()
    {
        return CRITICAL;
    }

    public int getAmmo()
    {
        return AMMO;
    }

    public void useAmmo()
    {
        if(AMMO > 0)
            AMMO--;
    }

    public String getName()
    {
        return NAME;
    }

    public String getTech()
    {
        return TECH;
    }

    public String getNick()
    {
        return NICKNAME;
    }

    public boolean isDestroyed()
    {
        return DESTROYED;
    }

    public void setDestroyed()
    {
        DESTROYED = true;
    }

    public int getCost()
    {
        return COST;
    }

}
