﻿using System;
using Lidgren.Network;


namespace Hook_FPS
{
    /// <summary>
    /// Game Server class using the Lidgren Network library.  Class structure from www.bakedon.com
    /// </summary>
    class GameServer
    {
        private NetServer server;
        private NetBuffer buffer;
        
        public event Action<NetConnection> ConnectionStatus;
        public event Action<NetConnection, NetBuffer> DataReceived;
        
        public GameServer()
        {
            var config = new NetConfiguration("Hook");
            config.Port = 54545;
            server = new NetServer(config);
            buffer = new NetBuffer();
        }
        
        public void Process()
        {
            NetMessageType type;
            NetConnection source;
            
            while (server.ReadMessage(buffer, out type, out source))
            {
                HandleMessage(buffer, type, source);
            }
        }
        
        private void HandleMessage(NetBuffer buffer, NetMessageType type, NetConnection source)
        {
            switch (type)
            {
                case NetMessageType.BadMessageReceived:
                    break;
                case NetMessageType.ConnectionApproval:
                    break;
                case NetMessageType.ConnectionRejected:
                    break;
                case NetMessageType.Data:
                    {
                        if (DataReceived != null)
                            DataReceived(source, buffer);
                        break;
                    }
                case NetMessageType.DebugMessage:
                    {
                        Console.WriteLine(buffer.ReadString());
                        break;
                    }
                case NetMessageType.NATIntroduction:
                    break;
                case NetMessageType.None:
                    break;
                case NetMessageType.OutOfBandData:
                    break;
                case NetMessageType.Receipt:
                    break;
                case NetMessageType.ServerDiscovered:
                    break;
                case NetMessageType.StatusChanged:
                    {
                        if (ConnectionStatus != null)
                            ConnectionStatus(source);
                        break;
                    }
                case NetMessageType.VerboseDebugMessage:
                    break;
                default: throw new NotImplementedException("Message type not handled: " + type.ToString());
            }
        }
    }
}
