﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

// The Game class maintains the state of the game, and is created once a player
// places all their ships.  The player state is passed to the game class, and it creates
// and instance of the AI Class to obtain the computer ship state. The game class monitors
// the game and it keeps track of the status of both the computer and player grids, and
// updates them as the game progresses.  
// It is also responsible for enforcing valid moves.

namespace Sea4
{
    class Game
    {
        String[,] playerShips;                                  //The arrays containing the state of computer and player ships
        String[,] computerShips;
        String difficulty;                                      //Difficulty setting, used to determine computer move

        private int playerShipCount;                            //used to load a game state from a file, since the two
        private int compShipCount;                              //may be different values

        String turn = "";                                       //the current turn, player or computer
        String firingResult = "";
        Color computerResult;                                   // firingResult is for player, computerResult computer
        String lastShipHit = "XX";                              // indicates whether the last move was a hit or miss
        String lastShipCompHit = "XX";                          // if a hit is achieved, the last ship hit is noted
        Boolean firstTimeHit = false;                           
        int hitX = 0;                                           // the location of the hit
        int hitY = 0;
        int missCounter = 0;                                    // used for hard/impossible mode, only a certain number
                                                                // of misses are permited
        AI ai;

        //constructor - takes player state, the initial number of ships, and difficulty. Used when
        //starting a new game.
        public Game(String[,] playerData, int numShips, String AISelected)
        {
            playerShips = playerData;
            playerShipCount = numShips;
            compShipCount = numShips;
            turn = "player";
            difficulty = AISelected;

            ai = new AI(numShips, difficulty);

            computerShips = ai.getCompShips();

            viewShips();           
        }

        //constructor - used to load a state from a file, when you already have both states and
        //potentially different number of ships, mode is the difficulty
        public Game(String[,] playerData, String[,] compData, int pShip, int cShip, String mode)
        {
            playerShips = playerData;
            computerShips = compData;
            playerShipCount = pShip;
            compShipCount = cShip;
            difficulty = mode;
            turn = "player";

            ai = new AI(compData, difficulty);

        }

        //sets the current turn, s is player or computer
        public void setTurn(String s)
        {
            turn = s;
        }

        //gets the current turn
        public String getTurn()
        {
            return turn;
        }

        //get the last ship player hit
        public String getLastShipHit()
        {
            return lastShipHit;
        }

        //get the number of player ships remaining
        public int getPlayerCount()
        {
            return playerShipCount;
        }

        //get the number of computer ships remaining
        public int getComputerCount()
        {
            return compShipCount;
        }

        //Detects whether the game is over
        public Boolean gameOver()
        {
            if (playerShipCount == 0 || compShipCount == 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        //Detects whether a ship has been sunk
        public Boolean shipSunk(String ship)
        {
            if (turn == "player")
            {
                for (int i = 0; i < computerShips.GetLength(0); i++)
                {
                    for (int j = 0; j < computerShips.GetLength(1); j++)
                    {
                        if (computerShips[i, j] == ship)
                        {
                            return false;
                        }
                    }
                }
                compShipCount--;
                return true;
            }
            else
            {
                for (int i = 0; i < playerShips.GetLength(0); i++)
                {
                    for (int j = 0; j < playerShips.GetLength(1); j++)
                    {
                        if (playerShips[i, j] == ship)
                        {
                            return false;
                        }
                    }
                }
                playerShipCount--;
                return true;
            }
        }

        //updates the game state after a player fires on the computer
        public void updateState(int x, int y, String result)
        {
            if (turn == "player")
            {
                computerShips[x, y] = result;
            }
        }

        //detects whether a choice was a valid move
        //some moves are unacceptable by the computer, depending on
        //the difficulty settings. For example, hard cant miss more than a few times.
        public Boolean validChoice(int x, int y)
        {
            if(turn == "player")
            {
                if (computerShips[x, y] != "MM" || computerShips[x,y] != "HH")
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                if (difficulty == "easy")
                {
                    if (playerShips[x, y] != "MM" && playerShips[x, y] != "HH")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else if (difficulty == "normal")
                {
                    if (playerShips[x, y] != "MM" && playerShips[x, y] != "HH")
                    {
                        if (firstTimeHit == true)
                        {
                            if (playerShips[x, y] == "XX" || playerShips[x, y] == lastShipCompHit)
                            {
                                if ((x == hitX + 1 || x == hitX - 1) && y == hitY)
                                {
                                    return true;
                                }
                                else if ((y == hitY + 1 || y == hitY - 1) && x == hitX)
                                {
                                    return true;
                                }
                                else
                                {
                                    return false;
                                }
                            }
                            else
                            {
                                return false;
                            }
                        }
                        else if (!compSunkShip() && lastShipCompHit != "XX")
                        {
                            if (playerShips[x, y] != lastShipCompHit)
                            {
                                return false;
                            }
                            else
                            {
                                return true;
                            }
                        }
                        else
                        {
                            return true;
                        }
                    }
                    else
                    {
                        return false;
                    }
                }
                else if (difficulty == "hard")
                {
                    if (playerShips[x, y] != "MM" && playerShips[x, y] != "HH")
                    {
                        if (firstTimeHit == true)
                        {
                            if (playerShips[x, y] == "XX" || playerShips[x, y] == lastShipCompHit)
                            {
                                if ((x == hitX + 1 || x == hitX - 1) && y == hitY)
                                {
                                    return true;
                                }
                                else if ((y == hitY + 1 || y == hitY - 1) && x == hitX)
                                {
                                    return true;
                                }
                                else
                                {
                                    return false;
                                }
                            }
                            else
                            {
                                return false;
                            }
                        }
                        else if (!compSunkShip() && lastShipCompHit != "XX")
                        {
                            if (playerShips[x, y] != lastShipCompHit)
                            {
                                return false;
                            }
                            else
                            {
                                return true;
                            }
                        }
                        else if (missCounter > 2)
                        {
                            if (playerShips[x, y] == "XX")
                            {
                                return false;
                            }
                            else
                            {
                                return true;
                            }
                        }
                        else
                        {
                            return true;
                        }
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    if (playerShips[x, y] != "MM" && playerShips[x, y] != "HH" && playerShips[x,y] != "XX")
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }

            }
        }

        //returns true if a computer sunk a ship
        public Boolean compSunkShip()
        {
            Boolean sunkShip = true;
            for (int i = 0; i < playerShips.GetLength(0); i++)
            {
                for (int j = 0; j < playerShips.GetLength(1); j++)
                {
                    if (playerShips[i, j] == lastShipCompHit)
                    {
                        sunkShip = false;
                    }
                }
            }
            return sunkShip;
        }

        //Creates the computer move for a game when 
        //it is the computers turn, difficulty is enforced in
        //the validmove method. It will continue to try
        //moves until it finds a valid choice.
        public void makeComputerMove()
        {
            ai.setMoveX();
            ai.setMoveY();
            while(!validChoice(ai.getX(), ai.getY()))
            {
                ai.setMoveX();
                ai.setMoveY();
            }
            if(playerShips[ai.getX(), ai.getY()] == "XX")
            {
                playerShips[ai.getX(), ai.getY()] = "MM";
                computerResult = Color.White;
                missCounter++;
            }
            else
            {
                if (lastShipCompHit != playerShips[ai.getX(), ai.getY()])
                {
                    firstTimeHit = true;
                }
                else
                {
                    firstTimeHit = false;
                }
                missCounter = 0;
                lastShipHit = playerShips[ai.getX(), ai.getY()];
                lastShipCompHit = playerShips[ai.getX(), ai.getY()];

                playerShips[ai.getX(), ai.getY()] = "HH";
                computerResult = Color.Red;
                hitX = ai.getX();
                hitY = ai.getY();
            }
        }

        //Returns the result of the computers last move
        public Color getComputerResult()
        {
            return computerResult;
        }

        //retruns the location on the ship grid "s" of the 
        //computers firing position.
        public String getComputerMove()
        {
            return "s" + ai.getX().ToString() + ai.getY().ToString();
        }

        //determines whether a player hit or missed,
        //if a hit, sets lastship hit to the ship
        //at that location
        public void playerFire(int x, int y)
        {
            if (computerShips[x, y] == "XX")
            {
                firingResult = "miss";
            }
            else
            {
                firingResult = "hit";
                lastShipHit = computerShips[x, y];
            }
        }

        //returns firing result of player
        public String getFiringResult()
        {
            return firingResult;
        }

        //returns computer ship state
        public String[,] getCompState()
        {
            return computerShips;
        }

        //returns the name of the ship that was last hit
        public String getLastShipHitLabel()
        {
            if (lastShipHit == "A1" || lastShipHit == "A2")
            {
                return "AIRCRAFT CARRIER";
            }
            else if (lastShipHit == "B1" || lastShipHit == "B2")
            {
                return "BATTLESHIP";
            }
            else if (lastShipHit == "F1" || lastShipHit == "F2")
            {
                return "FRIGATE";
            }
            else if (lastShipHit == "S1" || lastShipHit == "S2")
            {
                return "SUBMARINE";
            }
            else
            {
                return "PATROL BOAT";
            }
        }

        //cheating method.... used to debug and view the location of
        //computers ships. Only way to beat impossible mode.
        private void viewShips()
        {
            Console.WriteLine("PLAYER SHIPS");
            printGameState(playerShips);
            Console.WriteLine("");
            Console.WriteLine("COMPUTER SHIPS");
            printGameState(computerShips);
        }

        //prints the ship locations
        public void printGameState(String[,] gamestate)
        {
            for (int i = 0; i < gamestate.GetLength(0); i++)
            {
                for (int j = 0; j < gamestate.GetLength(1); j++)
                {
                    Console.Write(gamestate[i, j] + "  ");
                }
                Console.WriteLine("");
            }
        }
    }
}
