<?php
session_start();
include("includes.inc");
include("template/doJavascript.inc");
include("template/doHtml.inc");

// Error if no username set
if (!isset($_SESSION['newusername']))
{
  print("<p>There was an error, no username set.</p>");
  exit();
}

$page_title = 'Create Mentee Account';
headerWithJSEnter($page_title);
include("template/look.inc");

// Javascript to check for blank fields
echo '<script type="text/javascript" language="JavaScript">';
echo 'function validate() {';
echo '  if (document.createMentee.password.value == \'\')';
echo '    { alert("Password may not be blank."); return false; }';
echo '  else if (document.createMentee.email.value == \'\')';
echo '    { alert("Email may not be blank."); return false; }';
echo '  else if (document.createMentee.fname.value == \'\')';
echo '    { alert("First name may not be blank."); return false; }';
echo '  else if (document.createMentee.lname.value == \'\')';
echo '    { alert("Last name may not be blank."); return false; }';
echo '  var r = 0;';
echo '  if (document.createMentee.White.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Black.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Hispanic.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Native.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Asian.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Pacific.checked)';
echo '    { r++; }';
echo '  if (document.createMentee.Other.checked)';
echo '    { r++; }';
echo '  if (r == 0)';
echo '    { alert("Select race or ethnicity."); return false; }';
echo '  var i = 0;';
echo '  if (document.createMentee.mentor_field_ah.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_br.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_bh.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_m.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_n.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_oh.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_pa.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_ph.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.mentor_field_sw.checked)';
echo '    { i++; }';
echo '  if (document.createMentee.other.value != \'\')';
echo '    { i++; }';
echo '  if (i > 2)';
echo '    { alert("Select at most TWO health fields of interest."); return false; }';
echo '  return true;';
echo '}';
echo '</script>';

$username = $_SESSION['newusername'];
echo '<h2>Create Mentee Account</h2>';
echo '<div id="createMenteeAccount">';
echo '<ul>';
echo '<B><font color=red>Note</font></b>: Your personal information (e.g. phone, ethnicity, address, economic background) will be kept private and is only viewable by administrators and approved mentors.<br/>';
echo '<br/>';
echo '<form name="createMentee" action="createMenteeSubmit.php" method=post onSubmit="return validate();">';
echo '<b>User / Background / Demographics</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Username: ' . $username . '</td>';
echo '</tr>';
echo '<tr>';
echo '<td>&nbsp;</td>';
echo '</tr>';
echo '<tr>';
echo '<td>*Choose Password</td><td>*Email</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=password name=password size=25 maxlength=255></td>';
echo '<td><input type=text name=email size=25 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>*First Name</td><td>*Last Name</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="fname" size=25 maxlength=255></td>';
echo '<td><input type=text name="lname" size=25 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Street Address, State, Zip</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="address" size=57 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Phone</td><td>List the language(s) you MOST often use at home</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="phone" size=25 maxlength=25><br/>';
echo '<td><input type=text name="languages" size=25 maxlength=150></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Sex</td><td>Race / Ethnicity</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=radio name="sex" value="M" checked>Male<br/>';
echo '<input type=radio name="sex" value="F">Female</td>';

echo '<td>';
echo '<input type="checkbox" name="White">White<br/>';
echo '<input type="checkbox" name="Black">Black or African American<br/>';
echo '<input type="checkbox" name="Hispanic">Hispanic or Latino<br/>';
echo '<input type="checkbox" name="Native">Alaska Native or American Indian<br/>';
echo '<input type="checkbox" name="Asian">Asian<br/>';
echo '<input type="checkbox" name="Pacific">Native Hawaiian or Pacific Islander<br/>';
echo '<input type="checkbox" name="Other">Other<br/>';
echo '</td>';

echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Facebook name (if applicable)</td><td>Myspace name (if applicable)</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="facebook" size=25 maxlength=50><br/>';
echo '<td><input type=text name="myspace" size=25 maxlength=50></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Year born</td>';
echo '</tr>';
echo '<tr>';
echo '<td>';
/*
echo '<select name="bmonth">';
generateMonth("");
echo '</select>';
echo '&nbsp;<select name="bday">';
generateDay("");
echo '</select>';
*/
echo '<select name="byear">';
generateBirthYear();
echo '</select>';
echo '</td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Current city or town</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="curcity" size=25 maxlength=100></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Do you come from an economically disadvantaged background?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=radio name="disadvantaged" value="0" checked>No<br/>';
echo '<input type=radio name="disadvantaged" value="1">Yes</td>';
echo '</tr>';
echo '</table>';

echo '<p>';
echo '<br/>';
echo '</p>';
echo '<b>School Information</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>School name</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="school_name" size=25 maxlength=100></td>';
echo '</tr>';
echo '<tr>';
echo '<td>Year or grade in school</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="grade" size=25 maxlength=25></td>';
echo '</tr>';
echo '<tr>';
echo '<td>College major(s) (if in college)</td><td>Expected year of graduation (if in college)</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="major" size=25 maxlength=255></td>';
echo '<td><input type=text name="graduation_date" size=25 maxlength=25></td>';
echo '</tr>';
echo '<tr>';
echo '<td>Student ID (e.g. 30123456) if a UAA student</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="sid" size=25 maxlength=25></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>List possible career goals</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="3" name="career_goals"></textarea></td>';
echo '</tr>';
echo '<tr>';
echo '<td>List extracurricular activities</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="3" name="extracurricular"></textarea></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>What is the highest education level completed by either your father, mother, or guardian?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=radio name="parent_education_level" value="0" checked>Elementary (K-6)<br/>';
echo '<input type=radio name="parent_education_level" value="1">Junior High (7-8)<br/>';
echo '<input type=radio name="parent_education_level" value="2">High School (9-12)<br/>';
echo '<input type=radio name="parent_education_level" value="3">Some College<br/>';
echo '<input type=radio name="parent_education_level" value="4">Associate Degree<br/>';
echo '<input type=radio name="parent_education_level" value="5">Baccaulaureate Degree<br/>';
echo '<input type=radio name="parent_education_level" value="6">Post Graduate Degree<br/>';
echo '</td>';
echo '</tr>';
echo '</table>';

echo '<p>';
echo '<br/>';
echo '</p>';
echo '<b>Mentee Interests</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>I\'m interested in HEALTH DISPARITIES because...</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="4" name="interested_because"></textarea></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>If you were provided with a team of mentors from UAA <br/>and the community, what TWO health fields would you like<br/>your MENTORS to be from? (please check TWO)</td>';
echo '</tr>';
echo '<tr>';
echo '<td>';
echo '<input type="checkbox" name="mentor_field_ah">Allied Health<br/>';
echo '<input type="checkbox" name="mentor_field_br">Biomedical Research<br/>';
echo '<input type="checkbox" name="mentor_field_bh">Behavioral Health<br/>';
echo '<input type="checkbox" name="mentor_field_m">Medicine<br/>';
echo '<input type="checkbox" name="mentor_field_n">Nursing<br/>';
echo '<input type="checkbox" name="mentor_field_oh">Oral Health / Dentistry<br/>';
echo '<input type="checkbox" name="mentor_field_pa">Physician Assistant<br/>';
echo '<input type="checkbox" name="mentor_field_ph">Public Health<br/>';
echo '<input type="checkbox" name="mentor_field_sw">Social Work<br/>';
echo 'Other: <input type=text name="other" size=25 maxlength=100>';
echo '</td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>What health areas/topics would you like to be exposed to in research or practice?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="4" name="interested_topics"></textarea></td>';
echo '</tr>';
echo '</table>';


echo '<p>';
echo '<input type=submit value="Submit">';
echo '</p>';

echo '</form>';
echo '</ul>';
echo '</div>';

include("template/footer.inc");

?>
