<?php
session_start();
include("includes.inc");
include("template/doJavascript.inc");
include("template/doHtml.inc");

// Check if appropriate variables not set
if (!isset($_REQUEST['password']))
{
  print("<p>There was an error, appropiate variables not set.");
  exit();
}
if (!isset($_SESSION['newusername']))
{
  print("<p>There was an error, no username set.");
  exit();
}

$page_title = 'New Mentee Account';
headerWithJSEnter($page_title);
include("template/look.inc");

$username = $_SESSION['newusername'];
$password = $_REQUEST['password'];
$email = strip_tags($_REQUEST['email']);
$fname = strip_tags($_REQUEST['fname']);
$lname = strip_tags($_REQUEST['lname']);
$address = strip_tags($_REQUEST['address']);
$race = "";
if ($_REQUEST['White'])
  $race = "White";
if ($_REQUEST['Black'])
{
  if (strlen($race)>0)
	$race .= ", Black or African American";
  else
	$race = "Black or African American";
}
if ($_REQUEST['Hispanic'])
{
  if (strlen($race)>0)
	$race .= ", Hispanic or Latino";
  else
	$race = "Hispanic or Latino";
}
if ($_REQUEST['Native'])
{
  if (strlen($race)>0)
	$race .= ", Alaska Native or American Indian";
  else
	$race = "Alaska Native or American Indian";
}
if ($_REQUEST['Asian'])
{
  if (strlen($race)>0)
	$race .= ", Asian";
  else
	$race = "Asian";
}
if ($_REQUEST['Pacific'])
{
  if (strlen($race)>0)
	$race .= ", Native Hawaiian or Pacific Islander";
  else
	$race = "Native Hawaiian or Pacific Islander";
}
if ($_REQUEST['Other'])
{
  if (strlen($race)>0)
	$race .= ", Other";
  else
	$race = "Other";
}

$sex = strip_tags($_REQUEST['sex']);
$phone = strip_tags($_REQUEST['phone']);
$languages = strip_tags($_REQUEST['languages']);
$facebook = strip_tags($_REQUEST['facebook']);
$myspace = strip_tags($_REQUEST['myspace']);
//$bday = $_REQUEST['bday'];
//$bmonth = $_REQUEST['bmonth'];
$byear = strip_tags($_REQUEST['byear']);
$curcity = strip_tags($_REQUEST['curcity']);
$disadvantaged = strip_tags($_REQUEST['disadvantaged']);

$bday = 1;
$bmonth = 1;
if (strlen($bmonth)==1)
{
    $bmonth = '0' . $bmonth;
}
if (strlen($bday)==1)
{
    $bday = '0' . $bday;
}
$birthdate = $byear . '-' . $bmonth . '-' . $bday;
$school_name = strip_tags($_REQUEST['school_name']);
$grade = strip_tags($_REQUEST['grade']);
$graduation_year = strip_tags($_REQUEST['graduation_date']);
$sid = strip_tags($_REQUEST['sid']);
$major = strip_tags($_REQUEST['major']);
//$gpa = $_REQUEST['gpa'];
$career_goals = strip_tags($_REQUEST['career_goals']);
$extracurricular = strip_tags($_REQUEST['extracurricular']);
$parent_education_level = strip_tags($_REQUEST['parent_education_level']);
/*
if ($_REQUEST['both_parents_college']=='yes')
  $both_parents_college = 1;
else
  $both_parents_college = 0;
*/
$mentor_fields = array();
if ($_REQUEST['mentor_field_ah'])
  $mentor_fields[] = "Allied Health";
if ($_REQUEST['mentor_field_br'])
  $mentor_fields[] = "Biomedical Research";
if ($_REQUEST['mentor_field_bh'])
  $mentor_fields[] = "Behavioral Health";
if ($_REQUEST['mentor_field_m'])
  $mentor_fields[] = "Medicine";
if ($_REQUEST['mentor_field_n'])
  $mentor_fields[] = "Nursing";
if ($_REQUEST['mentor_field_oh'])
  $mentor_fields[] = "Oral Health / Dentistry";
if ($_REQUEST['mentor_field_pa'])
  $mentor_fields[] = "Physician Assistant";
if ($_REQUEST['mentor_field_ph'])
  $mentor_fields[] = "Public Health";
if ($_REQUEST['mentor_field_sw'])
  $mentor_fields[] = "Social Work";
$mentor_fields_all = "";
if (count($mentor_fields) > 0)
{
 $mentor_fields_all = $mentor_fields[0];
 for ($i = 1; $i < count($mentor_fields); $i++)
 {
   $mentor_fields_all = $mentor_fields_all . ", " . strip_tags($mentor_fields[$i]);
 }
}
if (strlen($_REQUEST['other'])>0)
{
   $mentor_fields_all = $mentor_fields_all . ", " . strip_tags($_REQUEST['other']);
}
$interested_because = strip_tags($_REQUEST['interested_because']);
$interested_topics = strip_tags($_REQUEST['interested_topics']);

echo '<h2>New Mentee Account</h2>';
echo '<div id="create">';
echo '<ul>';

// Insert the user
$sql = "INSERT INTO user SET username = '" . $username .
	"', password = '" . md5($password) .
	"', email = '" . $email .
	"', usertype = 1" .
	", fname = '" . $fname .
	"', lname = '" . $lname .
	"', phone = '" . $phone .
	"', sex = '" . $sex . 
	"', race = '" . $race .
	"', sid = '" . $sid .
	"', languages = '" . $languages .
	"', facebook = '" . $facebook .
	"', myspace = '" . $myspace .
	"', address = '" . $address .
	"', birthdate = '" . $birthdate .
	"', disadvantaged = " . $disadvantaged .
	", curcity = '" . $curcity .
	"';";
if (!mysql_query($sql))
{
	echo 'There was an error adding data to the user table.  Contact the system administrator.';
	exit();
}

// Insert school
$sql = "INSERT INTO mentee_school SET username = '" . $username .
	"', name = '" . $school_name .
	"', year = '" . $grade .
	"', graduation_year = '" . $graduation_year .
	"', major = '" . $major .
	"', career_goals = '" . $career_goals .
	"', parent_education_level = " . $parent_education_level .
	", extracurricular  = '" . $extracurricular .
	"';";
if (!mysql_query($sql))
{
	echo 'There was an error adding data to the mentee_school table.  Contact the system administrator. ';
	exit();
}

// Insert interests
$sql = "INSERT INTO mentee_interests SET username = '" . $username .
	"', interested_because = '" . $interested_because .
	"', mentor_field_pref = '" . $mentor_fields_all .
	"', interested_topics = '" . $interested_topics .
	"';";
if (!mysql_query($sql))
{
	echo 'There was an error adding data to the interests table.  Contact the system administrator.';
	exit();
}

echo '<b>Account created</b>';
echo '<p>';
echo 'The following mentee account has been created:<br/><br/>';
echo 'Username: ' . $username . '<br/>';
echo 'Email: ' . $email . '<br/><br/>';
echo 'A confirmation email has been sent to this address.  You may now log in by entering your username and password into the textboxes at the upper right of the screen and click on the Login button.';
echo '</p>';

// Email the account holder
$from = $email_address;
$to = $email;
$subject = "CAHDRE mentee account created";
$message = "Dear " . $fname . ",\n\nThank you for submitting a form to the Center for Addressing Health Disparities through Research and Education (CAHDRE) requesting a mentor.  We are working to match you with mentors.  A new mentee account has been set up with this email address in the online CAHDRE database.  To edit your profile, search mentors, search mentees, and view projects, you may log in at http://www.math.uaa.alaska.edu/~cahdre with the username '" . $username . "' and password of '" . $password . "'.\n\nThis password can be changed by logging into your account and editing your profile.  If you have any questions please contact the system administrator by replying to this email.";
sendEmail($from, $to, $subject, $message);

// Email the administrator
$from = $email_address;
$to = $notify_address;
$subject = "New CAHDRE mentee account created";
$message = "A new mentee account has been made for the user '" . $username . "'.  Please log in to http://www.math.uaa.alaska.edu/~cahdre/view_user.php?username=" . $username . " to view the profile.";
sendEmail($from, $to, $subject, $message);

//$to = "anrvc@uaa.alaska.edu";
//sendEmail($from, $to, $subject, $message);

echo '</ul>';
echo '</div>';

include("template/footer.inc");

?>
