<?php
session_start();
include("includes.inc");
include("template/doJavascript.inc");
include("template/doHtml.inc");

// Error if no username set
if (!isset($_SESSION['newusername']))
{
  print("<p>There was an error, no username set.</p>");
  exit();
}

$page_title = 'Create Mentor Account';
headerWithJSEnter($page_title);
include("template/look.inc");

// Javascript to check for blank fields
echo '<script type="text/javascript" language="JavaScript">';
echo 'function validate() {';
echo '  if (document.createMentor.password.value == \'\')';
echo '    { alert("Password may not be blank."); return false; }';
echo '  else if (document.createMentor.email.value == \'\')';
echo '    { alert("Email may not be blank."); return false; }';
echo '  else if (document.createMentor.fname.value == \'\')';
echo '    { alert("First name may not be blank."); return false; }';
echo '  else if (document.createMentor.lname.value == \'\')';
echo '    { alert("Last name may not be blank."); return false; }';
echo '  else if (document.createMentor.num_students.value == \'\')';
echo '    { alert("Number of students you would like to mentor may not be blank."); return false; }';
echo '  return true;';
echo '}';
echo '</script>';

$username = $_SESSION['newusername'];
echo '<h2>Create Mentor Account</h2>';
echo '<div id="createMentor">';
echo '<ul>';
echo '<br/>';
echo '<form name="createMentor" action="createMentorSubmit.php" method=post onSubmit="return validate();">';
echo '<b>User / Background / Demographics</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Username: ' . $username . '</td>';
echo '</tr>';
echo '<tr>';
echo '<td>&nbsp;</td>';
echo '</tr>';
echo '<tr>';
echo '<td>*Choose Password</td><td>*Email</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=password name=password size=25 maxlength=255></td>';
echo '<td><input type=text name=email size=25 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>*First Name</td><td>*Last Name</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="fname" size=25 maxlength=255></td>';
echo '<td><input type=text name="lname" size=25 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Sex</td><td>Race / Ethnicity</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=radio name="sex" value="M" checked>Male<br/>';
echo '<input type=radio name="sex" value="F">Female</td>';
echo '<td>';
echo '<input type="checkbox" name="White">White<br/>';
echo '<input type="checkbox" name="Black">Black or African American<br/>';
echo '<input type="checkbox" name="Hispanic">Hispanic or Latino<br/>';
echo '<input type="checkbox" name="Native">Alaska Native or American Indian<br/>';
echo '<input type="checkbox" name="Asian">Asian<br/>';
echo '<input type="checkbox" name="Pacific">Native Hawaiian or Pacific Islander<br/>';
echo '<input type="checkbox" name="Other">Other<br/>';
echo '</td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Phone</td><td>List languages you can speak other than English</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="phone" size=25 maxlength=25><br/>';
echo '<td><input type=text name="languages" size=25 maxlength=150></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Facebook name (if applicable)</td><td>Myspace name (if applicable)</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="facebook" size=25 maxlength=50><br/>';
echo '<td><input type=text name="myspace" size=25 maxlength=50></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>List all Baccalaureate degrees completed</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="2" name="bachelors"></textarea></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>List all Masters degrees completed</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="2" name="masters"></textarea></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>List all Doctorate degrees completed</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="2" name="doctorates"></textarea></td>';
echo '</tr>';
echo '</table>';

echo '<p>';
echo '<br/>';
echo '</p>';
echo '<b>Occupational Information</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Current occupation (type in "student" if currently a student)</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="occupation" size=50 maxlength=255></td>';
echo '</tr>';
echo '<tr>';
echo '<td>Where do you work (employer)?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="employer" size=50 maxlength=255></td>';
echo '</tr>';
echo '<tr>';
echo '<td>Department (if applicable)</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="department" size=50 maxlength=255></td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Number of years<br/>in current occupation</td><td>Does your current<br/>occupation involve addressing<br/>health disparities?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="years_work" size=15 maxlength=15></td>';
echo '<td><input type=radio name="health_disparities" value="yes" checked>Yes<br/>';
echo '<input type=radio name="health_disparities" value="no">No</td>';
echo '</tr>';
echo '</table>';

echo '<table border=0>';
echo '<tr>';
echo '<td>Please check the specific health area(s) that best represents the work you do.</td>';
echo '</tr>';
echo '<tr>';
echo '<td>';
echo '<input type="checkbox" name="mentor_field_ah">Allied Health<br/>';
echo '<input type="checkbox" name="mentor_field_br">Biomedical Research<br/>';
echo '<input type="checkbox" name="mentor_field_bh">Behavioral Health<br/>';
echo '<input type="checkbox" name="mentor_field_m">Medicine<br/>';
echo '<input type="checkbox" name="mentor_field_n">Nursing<br/>';
echo '<input type="checkbox" name="mentor_field_oh">Oral Health / Dentistry<br/>';
echo '<input type="checkbox" name="mentor_field_pa">Physician Assistant<br/>';
echo '<input type="checkbox" name="mentor_field_ph">Public Health<br/>';
echo '<input type="checkbox" name="mentor_field_sw">Social Work<br/>';
echo 'Other: <input type=text name="other" size=25 maxlength=100>';
echo '</td>';
echo '</tr>';
echo '</table>';

echo '<p>';
echo '<br/>';
echo '</p>';
echo '<b>Mentor Interests</b>';
echo '<p>';
echo '</p>';

echo '<table border=0>';
echo '<tr>';
echo '<td>I\'m interested in HEALTH DISPARITIES because...</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="4" name="interested_because"></textarea></td>';
echo '</tr>';
echo '<tr>';
echo '<td>List your relevant health research or practice of interest/focus</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="4" name="relevant_research"></textarea></td>';
echo '</tr>';
echo '<tr>';
echo '<td>How many students would you like to mentor?</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="num_students" width=10 maxlength=10></td>';
echo '</tr>';
echo '<tr>';
echo '<td>Approximately how much time can you dedicate for mentorship? Specify hours per month. Elaborate if necessary.</td>';
echo '</tr>';
echo '<tr>';
echo '<td><textarea cols="25" rows="2" name="time_available"></textarea></td>';
echo '</tr>';

echo '<tr>';
echo '<td>At what educational level would you prefer your mentees to be?</td>';
echo '</tr>';
echo '<tr>';
echo '<td>';
echo '<input type="checkbox" name="mentee_ed_level_k6">Elementary (K-6)<br/>';
echo '<input type="checkbox" name="mentee_ed_level_jr">Junior High (7-8)<br/>';
echo '<input type="checkbox" name="mentee_ed_level_hs">High School (9-12)<br/>';
echo '<input type="checkbox" name="mentee_ed_level_col">College<br/>';
echo '<input type="checkbox" name="mentee_ed_level_grad">Post Graduate<br/>';
echo '</td>';
echo '</tr>';

/*
echo '<tr>';
echo '<td><br/>If you prefer your mentees to be a specific grade level(s), please enter it below.  Use 0 for kindergarten, 6 for sixth grade, 12 for high school seniors, 13 for college freshman, etc.</td>';
echo '</tr>';
echo '<tr>';
echo '<td><input type=text name="specific_grade_level" width=10 maxlength=100></td>';
echo '</td>';
echo '</tr>';
*/
echo "<input type=hidden name='specific_grade_level' value=0>";


echo '</table>';


echo '<p>';
echo '<input type=submit value="Submit">';
echo '</p>';

echo '</form>';
echo '</ul>';
echo '</div>';

include("template/footer.inc");

?>
