<?php
	include("../includes.inc");

	$createDatabase_sql = "CREATE DATABASE IF NOT EXISTS $database_name;";
	$selectDatabase_sql = "USE $database_name;";

	//usertype 1 = mentee, 2 = mentor, 3 = admin
	$user_sql = "CREATE TABLE user (
				username varchar(255) NOT NULL,
				password varchar(255) default '',
				usertype int(4) NOT NULL default '1',
				picture varchar(255) default 'nopic',
				disadvantaged int(4) default '0',
				sid varchar(12) default '',
				email varchar(255) default '',
				lname varchar(255) default '',
				fname varchar(255) default '',
				phone varchar(255) default '',
				sex varchar(2) default 'M',
				race varchar(255) default '',
				languages varchar(255) default '',
				facebook varchar(255) default '',
				myspace varchar(255) default '',
				address varchar(255) default '',
				curcity varchar(255) default '',
				birthdate date default NULL,
				bachelors varchar(255) default '',
				masters varchar(255) default '',
				doctorates varchar(255) default '',
				modification_date timestamp(14) NOT NULL,
				PRIMARY KEY (username),
				INDEX (username),
				UNIQUE KEY (username)
				) ENGINE = INNODB;";

	// both_parents_college: 0 = no, 1 = yes
	$mentee_school= "CREATE TABLE mentee_school (
				username varchar(255) NOT NULL,
				name varchar(255) default '',
				year varchar(50) default '',
				graduation_year varchar(5) default '2015',
				major varchar(100) default '',
				career_goals text default '',
				extracurricular text default '',
				gpa varchar(10) default '',
				parent_education_level int(4) default '1',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;";

	$mentee_interests = "CREATE TABLE mentee_interests (
				username varchar(255) NOT NULL,
				interested_because text default '',
				mentor_field_pref varchar(255) default '',
				interested_topics text default '',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;";

	// health_disparities: 0 = no, 1 = yes
	$mentor_occupation = "CREATE TABLE mentor_occupation (
				username varchar(255) NOT NULL,
				occupation varchar(255) default '',
				employer varchar(255) default '',
				department varchar(255) default '',
				years_work int(4) default '0',
				mentor_fields varchar(255) default '',
				health_disparities int(4) default '0',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;";

	$mentor_interests = "CREATE TABLE mentor_interests (
				username varchar(255) NOT NULL,
				interested_because text default '',
				relevant_research text default '',
				num_students int(4) default '0',
				time_available varchar(255) default '',
				specific_grade_level varchar(100) default '',
				mentee_educational_level varchar(100) default '',
				PRIMARY KEY (username),
				FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
				) ENGINE = INNODB;";

	//project_status: 1 = new/in progress, 2 = complete
	//seeking_help: 0 = no, 1 = yes
	$project_sql = "CREATE TABLE project (
					project_id int(10) unsigned NOT NULL auto_increment,
					project_title varchar(255) default '',
					abstract text default '',
					status int(4) NOT NULL 	default '0',
					start_date date NOT NULL,
					end_date date NOT NULL,
					funding_source varchar(255) default '',
					funding_amount varchar(255) default '',
					course varchar(255) default '',
					partner varchar(255) default '',
					seeking_help int(4) default '1',
					modification_date timestamp(14) NOT NULL,
					PRIMARY KEY (project_id),
					INDEX (project_id),
					INDEX (status)
					) ENGINE = INNODB;";

	$keywordproject_sql = "CREATE TABLE keywordproject (
					project_id int(10) unsigned NOT NULL,
					k_id int(10) unsigned NOT NULL,
					PRIMARY KEY (project_id, k_id),
					INDEX (project_id),
					INDEX (k_id),
					FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE,
					FOREIGN KEY (k_id) REFERENCES keyword(k_id) ON DELETE CASCADE
					)ENGINE = INNODB;";
	$keyword_sql =  "CREATE TABLE keyword (
					k_id int(10) unsigned NOT NULL auto_increment,
					k_word varchar(255) NOT NULL,
					PRIMARY KEY (k_id),
					UNIQUE KEY (k_id)
					) ENGINE = INNODB;";

	// userstatus: 1=active, 0=inactive
	// standing_started: class standing of user when added to project
	//			or "mentor" if a faculty mentor
	$userproject_sql = "CREATE TABLE userproject (
						project_id int(10) unsigned NOT NULL,
						username varchar(255) NOT NULL,
						userstatus int(4) default '0',
						standing_started varchar(50) default '',
						PRIMARY KEY (project_id, username),
						INDEX (project_id),
						INDEX (username),
						FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE
						) ENGINE = INNODB;";

	$projectfile_sql = "CREATE TABLE projectfile (
						project_id int(10) unsigned NOT NULL,
						username varchar(255) NOT NULL,
						filename varchar(255) default '',
						description varchar(255) default '',
						modification_date timestamp(14) NOT NULL,
						PRIMARY KEY(project_id, username, filename),
						INDEX (project_id),
						INDEX (username),
						INDEX (filename),
						FOREIGN KEY (project_id) REFERENCES project(project_id) ON DELETE CASCADE
						) ENGINE = INNODB;";

	$userfile_sql = "CREATE TABLE userfile (
					username varchar(255) NOT NULL,
					filename varchar(255) default '',
					description text default '',
					PRIMARY KEY (username, filename),
					INDEX (username),
					INDEX (filename),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;";

	$activated_sql = "CREATE TABLE activated (
					username varchar(255) NOT NULL,
					status int(10) unsigned NOT NULL,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;";

	$administrator_sql = "CREATE TABLE administrator (
					username varchar(255) NOT NULL,
					privilegelevel tinyint default 0,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;CREATE TABLE administrator (
					username varchar(255) NOT NULL,
					privilegelevel tinyint default 0,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;";

	$usagestatistic_sql = "CREATE TABLE usagestatistic (
					generation_date date NOT NULL,
					total_mentors int(10) unsigned NOT NULL,
					total_mentees int(10) unsigned NOT NULL,
					total_projects int(10) unsigned NOT NULL,
					total_page_hits int(10) unsigned NOT NULL,
					unique_page_hits int(10) unsigned NOT NULL,
					PRIMARY KEY (generation_date)
					) ENGINE = INNODB;";

	$websitevisit_sql = "CREATE TABLE websitevisit (
					hit_id int(10) unsigned NOT NULL auto_increment,
					ip_address varchar(255) NOT NULL,
					timestamp datetime NOT NULL,
					PRIMARY KEY (hit_id),
					INDEX (ip_address)
					) ENGINE = INNODB;";

	$userlogin_sql = "CREATE TABLE userlogin (
					username varchar(255) NOT NULL,
					num_logins int(10) NOT NULL,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;";

	$userfeedback_sql = "CREATE TABLE userfeedback (
					username varchar(255) NOT NULL,
					survey_declined bool NOT NULL,
					search_feedback int(2),
					project_feedback int(2),
					overall_feedback int(2),
					comments text,
					PRIMARY KEY (username),
					INDEX (username),
					FOREIGN KEY (username) REFERENCES user(username) ON DELETE CASCADE
					) ENGINE = INNODB;";


	//start creating database and tables

	echo"<br>Making the database...";
	if(!mysql_query($createDatabase_sql))
	{
		echo("<b>Database not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error());
		echo("<br>");
	}
	else
	{
		echo("<b>Database successfully created</b><br>");
		mysql_query($selectDatabase_sql);
	}
	//drop all existing tables
	echo"Deleting tables...";
	$query = "SHOW TABLES";
	$result = mysql_query($query);
	$table_info = mysql_fetch_array($result);

	//$table_info[0] : table name
	while($table_info != false)
	{
		echo"Deleting from " . $table_info[0] . "...<br>";
		mysql_query("DELETE FROM" . $table_info[0] . ";");
		$table_info = mysql_fetch_array($result);
	}
	$query = "SHOW TABLES";
	$result = mysql_query($query);
	$table_info = mysql_fetch_array($result);
	while($table_info != false)
	{
		echo"Dropping " . $table_info[0] . "...<br>";
		mysql_query("DROP TABLE" . $table_info[0] . ";");
		$table_info = mysql_fetch_array($result);
	}

	echo"Creating user table...";
	if(!mysql_query($user_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating mentee_school table...";
	if(!mysql_query($mentee_school))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating mentee interests table...";
	if(!mysql_query($mentee_interests))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating mentor occupation table...";
	if(!mysql_query($mentor_occupation))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating mentor interests table...";
	if(!mysql_query($mentor_interests))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating project table...";
	if(!mysql_query($project_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating user project table...";
	if(!mysql_query($userproject_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}
	echo"Creating project file table...";
	if(!mysql_query($projectfile_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}
	echo"Creating user file table...";
	if(!mysql_query($userfile_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating keyword table...";
	if(!mysql_query($keyword_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating keywordproject table...";
	if(!mysql_query($keywordproject_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating activation table...";
	if(!mysql_query($activated_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating administrator table...";
	if(!mysql_query($administrator_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating usagestatistic table...";
	if(!mysql_query($usagestatistic_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating websitevisit table...";
	if(!mysql_query($websitevisit_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating userlogin table...";
	if(!mysql_query($userlogin_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

	echo"Creating userfeedback table...";
	if(!mysql_query($userfeedback_sql))
	{
		echo"<b>Table not created.</b><br>MySQL Error: " . mysql_errno() . " -> " . mysql_error();
		echo"<br>";
	}
	else
	{
		echo"<b>Table successfully created </b><br>";
	}

?>

