<?php

class AOCourse extends ActiveObject {
	public $IMG_SRC = '/images/blackboardLogo.png';
	
	public $pk1;
	public $crn;
	
	/**
	 * Instantiates the course through it's ID variable using
	 * the Blackboard database.
	 **/
	public function __construct($id) {
		$CI =& get_instance();
		$CI->load->model('Coursemodel');
		
		$info = $CI->Coursemodel->get($id);
		if(!$info) $info = $CI->Coursemodel->getByCourseID($id);
		
		if(!$info) throw new Exception("Blackboard account could not be found");

		$this->pk1 = $info->pk1;
		$this->url = "/course/info/" . $this->pk1;
		$this->name = $info->course_name;
		$this->crn = $info->course_id;
		$this->id = $this->pk1;
	}
	
	/**
	 * Restores a course account from the stored session variable.
	 **/
	public static function restoreFromSession() {
		$CI =& get_instance();
		$id = $CI->session->userdata('activeObjectId');
		
		$ao = new AOCourse($id); 
		if(empty($ao)) return null;
		return $ao;
	}
	
	/**
	 * Saves the current user account to the session variable.
	 **/
	public function saveToSession() {
		$CI =& get_instance();
		$CI->session->set_userdata('activeObjectId', $this->id);
	}

}

?>