<?php

abstract class ModuleClass {
	private $CI;
	
	//Result caching
	private static $hasSunOneAccount = null;
	private static $hasFederatedAccount = null;
	private static $hasADAccount = null;
	
	public function __construct() {
		$this->CI =& get_instance();
	}
	
	/**
	 * Prints out a default view for a module index. This method should generally be overriden by
	 * any module wanting to appear in the left navigation.
	 **/
	public function index() {
		renderDefault("<p>This is the default index for a module. Override the <em>index()</em> function in your class to define your own.</p>");
	}
	
	/**
	 * Allows modules to control the currently stored Session variables and retrieve them.
	 * If a $value is provided, the method will return true if the variable was set or
	 * false upon failure.
	 **/
	protected function session($key, $value = null) {
		if(is_null($value)) return $this->CI->session->userdata($key);
		else {
			try {
				$this->CI->session->set_userdata(array($key => $value));
				return true;
			}
			catch(Exception $e) {
				return false;
			}
		}
	}
	
	/**
	 * Allows modules to cross-call other module's methods by returning that module's instance.
	 * This is generally discouraged as it couples the two modules together. Consider merging the two
	 * modules before using this method.
	 **/
	public function module($moduleName) {
		return $this->CI->moduleloader->getInstance($moduleName);
	}
	
	/**
	 * Returns the currently set Active Object. A type check can also be performed upon retrieval
	 * by passing an Active Object constant into the $type parameter (ie. ActiveObject::USER)
	 *
	 * Throws ActiveObjectRequiredException if an Active Object is not found or if it fails the type check.
	 **/
	protected function activeObject($type = null) {
		$ao = $this->CI->activeobjectloader->get();
		if(!$ao || ($type != null && !(is_a($ao, $type)))) throw new ActiveObjectRequiredException();
		return $ao;
	}
	
	
	/**
	 * Returns an instance of the SunOne LDAPDirectory database connection.
	 **/
	protected function sunone() {
		$this->CI->load->library('sunone');
		return $this->CI->sunone;
	}
	
	/**
	 * Used by modules to determine if Active Objects have database accounts that exist for their credentials.
	 * The return value for this is cached and is therefore much preferred to individual checks at the
	 * module level.
	 **/
	public function hasSunOneAccount() {
		if(is_null(self::$hasSunOneAccount)) {
			$ao = $this->activeObject(ActiveObject::USER);
			self::$hasSunOneAccount = $this->sunone()->get($ao, array('dn')) == true;
		}
		
		return self::$hasSunOneAccount;
	}
	
	/**
	 * Returns an instance of the Federated LDAPDirectory database connection.
	 **/
	protected function federated() {
		$this->CI->load->library('federated');
		return $this->CI->federated;
	}

	/**
	 * Used by modules to determine if Active Objects have database accounts that exist for their credentials.
	 * The return value for this is cached and is therefore much preferred to individual checks at the
	 * module level.
	 **/
	public function hasFederatedAccount() {
		if(is_null(self::$hasFederatedAccount)) {
			$ao = self::$activeObject(ActiveObject::USER);
			self::$hasFederatedAccount = $this->federated()->get($ao, array('dn')) == true;
		}
		
		return self::$hasFederatedAccount;
	}

	/**
	 * Returns an instance of the Active Directory LDAPDirectory database connection.
	 **/
	protected function ad() {
		$this->CI->load->library('ActiveDirectory');
		return $this->CI->activedirectory;
	}


	/**
	 * Used by modules to determine if Active Objects have database accounts that exist for their credentials.
	 * The return value for this is cached and is therefore much preferred to individual checks at the
	 * module level.
	 **/
	public function hasADAccount() {
		if(is_null(self::$hasADAccount)) {
			$ao = $this->activeObject(ActiveObject::USER);
			self::$hasADAccount = $this->ad()->get($ao, array('dn')) == true;
		}
		
		return self::$hasADAccount;
	}

	/**
	 * Returns an instance of the Blackboard Microsoft SQL Server database model.
	 **/
	protected function blackboard() {
		$this->CI->load->model('Coursemodel');
		return $this->CI->Coursemodel;
	}
	
	/**
	 * Returns an instance of the Commonspot Microsoft SQL Server database model.
	 **/
	protected function cms() {
		$this->CI->load->model('Cmsmodel');
		return $this->CI->Cmsmodel;
	}
	
	/**
	 * Helper method for creating log entries that automatically provides the currently logging module name.
	 **/
	protected function log($action, $entry) {
		log_entry(get_class($this), $action, $entry);
	}

	/**
	 * Helper method for creating error log entries that automatically provides the currently logging module name.
	 **/
	protected function error($action, $entry) {
		log_error(get_class($this), $action, $entry);
	}
	
	/**
	 * Helper method for rendering Smarty templates that that automatically fills in the module's path.
	 **/
	protected function render($templateName = null, array $data = null) {
		render(MODULE_PATH . get_class($this) . "\\" . $templateName, $data);
	}

	/**
	 * Helper method for rendering Smarty templates that forwards to the main renderDefault helper function.
	 **/
	protected function renderDefault($data = null) {
		renderDefault($data);
	}
	
	/**
	 * Helper method for rendering Smarty templates that forwards to the main renderError helper function.
	 **/
	protected function renderError($content = null, $returnURL = null, Exception $e = null) {
		renderError($content, $returnURL, $e);
	}
}

?>