<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Logentries extends CI_Controller {

	function __construct() {
		parent::__construct();
		
		$this->load->model('logmodel');
	}

	function index() {
		redirect('/logentries/view/');
	}
	
	function module($module) {
		redirect("/logentries/view/$module");
	}
	
	function view($module = null, $offset = 0) {
		if(is_numeric($module)) {
			$offset = $module;
			$module = null;
		}
		
		$entryCount = $this->logmodel->numberOfEntries($module);
		$perPage = 50;
		
		$entries = $this->logmodel->getAllEntries($module, $perPage, $offset);
		
		$this->load->library('pagination');
		$config['uri_segment'] = is_null($module) ? 3 : 4;
		$config['full_tag_open'] = '<p style="text-align: center;">';
		$config['full_tag_close'] = '</p>';
		$config['base_url'] = "/logentries/view/$module/";
		$config['total_rows'] = $entryCount;
		$config['per_page'] = $perPage;
		$this->pagination->initialize($config);
		
		$this->smartyparser->assign('pagination', $this->pagination->create_links());
		$this->smartyparser->assign('logEntries', $entries);
		$this->smartyparser->display('log.tpl');
	}
}