<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Module extends CI_Controller {

	function index() {
		$this->smartyparser->assign('moduleList', $this->moduleloader->getModuleListByCategory());
		$this->smartyparser->display('moduleList.tpl');
	}
	
	function load($moduleName = null) {
		if(is_null($moduleName)) redirect("/" . get_class());
		
		$params = $this->uri->segment_array();
		
		try {
			$instance = $this->moduleloader->getInstance($moduleName);
		
			//If we haven't provided a function call to send to the module, call the index
			if(count($params) < 4) $instance->index();
			else {
				//Otherwise call the module's function
				$functionName = $params[4];
				$params = array_slice($params, 4);
			
				if(is_callable(array($instance, $functionName))) {
					$ret = call_user_func(array($instance, $functionName), $params);
					if($ret === false) print 0;
					elseif($ret === true) print 1;
					else print $ret;
				}
				else throw new Exception("Module method '$functionName' cannot be called.");
			}
		}
		catch(ActiveObjectRequiredException $e) {
			if(!$this->input->is_ajax_request())
				renderError(null, null, $e);
			else
				print $e->getMessage();
		}
		catch(Exception $e) {
			if(!isset($functionName)) $functionName = 'Function Call';
			log_error($moduleName, $functionName, $e->getMessage());
			
			if(!$this->input->is_ajax_request())
				renderError("An error was encountered in the $functionName method. Cannot complete action.", null, $e);
			else
				print "An error was encountered in the $functionName method. Cannot complete action.";
		}
	}
}

?>