<?php


/**
 * Create an entry in the log for the specified module. If the module is not
 * provided, this method assumes that the application is making the log entry.
 **/
function log_entry($module, $action, $entry) {
	if(empty($module)) $module = 'Application';
	
	$CI =& get_instance();
	$CI->load->model('logmodel');
	$CI->logmodel->addNotice($module, $action, $entry);
	
}

/**
 * Create an error entry in the log for the specified module. If the module is not
 * provided, this method assumes that the application is making the log entry.
 *
 * An error message will also be displayed on the page if development mode is enabled.
 **/
function log_error($module, $action, $entry) {
	if(empty($module)) $module = 'Application';
	
	$CI =& get_instance();
	$CI->load->model('logmodel');
	$CI->logmodel->addError($module, $action, $entry);

	if(ENVIRONMENT == 'development') {
	?>
		<div class='error'>
			<p>
				<strong>Error reported in <?php print $module; ?></strong><br/>
				<strong>Event:</strong> <?php print $action; ?><br/>
				<strong style='display: inline-block;'>Message:</strong> <?php print $entry; ?>
			</p>
		</div>
	<?php
	}
}


?>