<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once('ActiveDirectory.php');

class Federated extends ActiveDirectory {
	protected $defaultSearchAttributes = array("uaIdentifier", "displayName", "name", 'givenname', 'sn', 'accountExpires', 'uaRoleExpiration', 'initials');

    function __construct() {
		parent::__construct('federated');
    }
	
	protected function process(&$attributes) {
		//Process database-specific attributes
		if(isset($attributes['accountExpires'])) {
			foreach($attributes['accountExpires'] as &$attribute) {
				$attribute = date('n/j/Y h:i A', self::parseDate($attribute));
			}
		}
		
		if(isset($attributes['uaRoleExpiration'])) {
			foreach($attributes['uaRoleExpiration'] as &$attribute) {
				$tmp = explode(":", $attribute);
				$tmp[1] = date('n/j/Y h:i A', self::parseDate($tmp[1]));
				
				$attribute = array('name' => $tmp[0], 'expiry' => $tmp[1]);
			}
		}
	}
	
	protected function getAuthUsernames($user) {
		$usernames = array();
		array_push($usernames, "cn=". $user .",ou=userAccounts,dc=ua,dc=ad,dc=alaska,dc=edu");
	
		return $usernames;
	}
}


?>