<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Gmail {
	private $auth;
	private $client;
	private $gdata;
	
	function __construct() {
		require_once 'Zend/Loader.php';
		Zend_Loader::loadClass('Zend_Gdata_ClientLogin');
		Zend_Loader::loadClass('Zend_Gdata_Gapps');
		$CI =& get_instance();
		$CI->load->config('auth', TRUE);
		$this->auth = &$CI->config->item('auth');
		
		#open a session against the gmail instance and create a gdata object
		$this->client = Zend_Gdata_ClientLogin::getHttpClient($this->auth['google']['EMAIL'], $this->auth['google']['PASS'], 'apps');
		$this->gdata = new Zend_Gdata_Gapps($this->client, $this->auth['google']['DOMAIN']);
    }
	
	public function get($username) {
		if($username instanceof ActiveObject) return $this->getUser($username->uid);
		else return $this->getUser($username);
	}
	
	public function createUser($gmailUsername, $gmailGivenName, $gmailSurname, $gmailPassword = null, $uaid) {
		if(is_null($gmailPassword)) $gmailPassword = $this->auth['google']['DEFAULTPASS'];

		// If a user already exists just return it
		if($this->get($gmailUsername)) {
			return $this->get($gmailUsername);
		}
		else {
			#create the user in gmail
			$this->gdata->createUser($gmailUsername, $gmailGivenName, $gmailSurname, $gmailPassword);
			$this->updateFbk($uaid, $gmailUsername);
		}

		return $this->getUser($gmailUsername);
	}
	
	private function getUser($username) {
		return $this->gdata->retrieveUser($username);
	}
	
	/**
	 *Function to update the FBK database
	 **/
	private function updateFbk($uniqueIdentifier, $username) {
		$CI =& get_instance();
		$userInfo = "$uniqueIdentifier,$username,Student,optinUAA";

		#$devurl = "https://cms-test.alaska.edu/google-test/opt-in/upload/uploadConfirm.xml?myFile=$userInfo";
		$url = "https://www.alaska.edu/google/opt-in/upload/uploadConfirm.xml?myFile=$userInfo";

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $this->auth['roxen']['USER'] . ":" . $this->auth['roxen']['PASS']);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, 1);
		$data = curl_exec($ch);

		$success = false;
		if (strlen(strstr($data, "Record(s) inserted"))>0)	$success = true;

		return $success;
	}
}


?>