<?php


class Logmodel extends CI_Model {
	private $dbConn;

	public function __construct() {
		parent::__construct();
		
		$this->dbConn = $this->load->database('default', true);
	}

	public function getAllEntries($moduleName = null, $limit = 50, $offset = 0) {
		$offsetStart = intval($offset);
		$offsetEnd = $offsetStart + $limit;
		
		$moduleStr = is_null($moduleName) ? "" : "WHERE module = ?";
		$query = $this->dbConn->query("WITH temp AS (SELECT *, ROW_NUMBER() OVER (ORDER BY timestamp DESC) AS rownum FROM Log $moduleStr) SELECT * FROM temp WHERE rownum BETWEEN $offsetStart AND $offsetEnd", array($moduleName));
		
		return $query->result();
	}
	
	public function numberOfEntries($moduleName = null) {
		$moduleStr = is_null($moduleName) ? "" : "WHERE module = ?";
		$query = $this->dbConn->query("SELECT COUNT(id) AS count FROM Log $moduleStr", array($moduleName))->row();
		return $query->count;
	}
	
	public function addNotice($moduleName, $action, $entry) {
		$this->dbConn->query("INSERT INTO Log (timestamp, module, [user], [level], action, entry) VALUES(CURRENT_TIMESTAMP, ?, ?, 'NOTICE', ?, ?)", array($moduleName, $_SERVER['AUTH_USER'], $action, $entry));
	}
	
	public function addError($moduleName, $action, $entry) {
		$this->dbConn->query("INSERT INTO Log (timestamp, module, [user], [level], action, entry) VALUES(CURRENT_TIMESTAMP, ?, ?, 'ERROR', ?, ?)", array($moduleName, $_SERVER['AUTH_USER'], $action, $entry));
	}
}


?>