{if $smarty.const.ENVIRONMENT == 'development'}

<!-- ActiveObject Contents:
{$ao|@print_r|default:""}
-->
{/if}
<!DOCTYPE html>
<html>
<!-- Content Copyright University of Alaska at Anchorage -->
<head>
	<meta name="Description" id="Description" content="IT Services Call Center Dashboard" />
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta name="Keywords" id="Keywords" content="" />
	
	<!-- Javascript Libraries -->
	<script type="text/javascript" src="/javascript/jquery-1.5.min.js"></script>
	<!-- Custom jQuery UI containing Draggable, Resizable, Sortable and Dialog components -->
	<script type="text/javascript" src="/javascript/jquery-ui-1.8.7.custom.min.js"></script>

		
	<script type="text/javascript" src="/javascript/uaa.js"></script>
	<!--<script type="text/javascript" src="/javascript/DenaliView.js"></script>-->


	<!-- Stylesheets -->
	<link type="text/css" rel="stylesheet" href="/style/DenaliView.css" />
	<link type="text/css" rel="stylesheet" media="print" href="/style/print.css" />
	<link rel="stylesheet" href="/javascript/jsTree/theme/style.css" />
	<!-- Custom jQuery UI containing CSS for all components -->
	<link rel="stylesheet" href="/javascript/jquery-ui-1.8.7.custom.css" />
	<!--[if lte IE 8]>
	<link type="text/css" rel="stylesheet" href="/style/ie.css" />
	<![endif]-->
	<!--[if lte IE 6]>
	<link type="text/css" rel="stylesheet" href="/style/ie6.css" />
	<![endif]-->
	
	<title>{strip}{block name=title}{/block}{/strip} IT Services Call Center Dashboard - University of Alaska Anchorage</title>
	<link type='text/css' rel='stylesheet' href='/style/style.css' />
	<script type='text/javascript' src='/javascript/ITCC.js'></script>
	
	{block name=head}{/block}
	{block name=scripts}{/block}
	{block name=styles}{/block}
	{block name=debug}{/block}
</head>
<body class='{block name=bodyclass}{/block}'>
	{if $smarty.const.ENVIRONMENT != 'production'}<span style='position: absolute; z-index: 1000; left: 0; top: 0; text-align: center; background-color: red; background-color: rgba(255, 0, 0, 0.6); color: white; font-weight: bold; padding: 5px 20px;'>NOTE: Currently running in {$smarty.const.ENVIRONMENT|upper} mode</span>{/if}
	<div id="header">
		<div class='frame'>
			<div id="topnav">
				<div><a href="#content">Skip Navigation</a> | <a href="http://www.uaa.alaska.edu/map/">Campus Map</a> | <a href="http://www.uaa.alaska.edu/atoz/">A to Z</a> | <a href="http://www.uaa.alaska.edu/directory.cfm">Directory</a></div>
				{if isset($activeObject)}
				<div id='activeObject'>
					<a href='{$activeObject->url}'>
						<div class='info'>
							<div class='name'>{$activeObject->name|default:''}</div>
							{if $activeObject instanceof ActiveObject::USER}
								<div class='UAID'>{$activeObject->id|default:''}</div>
								<div class='UID'>{$activeObject->uid|default:''}</div>
							{elseif $activeObject instanceof ActiveObject::COURSE}
								<div class='UID'>{$activeObject->crn|default:''}</div>
							{/if}
						</div>
						<img class='image' src='{$activeObject->IMG_SRC}' alt='' />
					</a>
				</div>
				{/if}
			</div>
			<div id="logo">
				<a href="/"><img src='/images/ITS.jpg' alt='University of Alaska Anchorage IT Services' /></a>
			</div>
			<div class='clear'></div>
		</div>
	</div>

	<div class='frame glow'>
		<div id="main">
			<div id="topbar">
				<form action="/search/" method="post" id="search">
					<select id="searchFilter" name='filter'>
						<option value=''>Search</option>
						<optgroup label='User Accounts'>
							<option {if isset($filter) && $filter == 'uaid'}SELECTED{/if} value='uaid'>UA ID</option>
							<option {if isset($filter) && $filter == 'username'}SELECTED{/if} value='username'>Username</option>
							<option {if isset($filter) && $filter == 'name'}SELECTED{/if} value='name'>First/Last Name</option>
						</optgroup>
						<optgroup label='Classes'>
							<option {if isset($filter) && $filter == 'crn'}SELECTED{/if} value='crn'>CRN</option>
							<option {if isset($filter) && $filter == 'description'}SELECTED{/if} value='description'>Class Description</option>
							<option {if isset($filter) && $filter == 'instructor'}SELECTED{/if} value='instructor'>Instructor</option>
						</optgroup>
					</select>
					<input type="search" id="searchQ" name='search' value='{$search|default:''}' />
				</form>
				<div id="breadcrumb">
					<a href='http://callcenter.uaa.alaska.edu/'>IT Services Call Center</a> <span>&gt;</span>
					{if count($breadcrumbs) == 0}
						<span>Dashboard</span>
					{else}
						<a href='/'>Dashboard</a> <span>&gt;</span>
						{foreach $breadcrumbs as $breadcrumb}
							{if !$breadcrumb@last}
								<a href='{$breadcrumb.url}'>{$breadcrumb.name|capitalize}</a> <span>&gt;</span>
							{else}
								<span>{$breadcrumb.name|capitalize}</span>
							{/if}
						{/foreach}
					{/if}
				</div>
				<div class='clear'></div>
			</div>
			
			<!-- Display Splash Image -->
			<div id="splash">
				{block name=splash}{/block}
			</div>
			<div id="sidebar" class='aside'>
				<div id="leftnav" class='nav jstree jstree-0'>
					<ul>
						<li><a href="/">Dashboard</a>
							<ul>
							{foreach $leftnav as $category => $modules}
								{if $category != 'Uncategorized'}
								<li><a href=''>{$category}</a>
									<ul>
										{foreach $modules as $module}
										<li><a href='{$module.url|default:"/pageNotFound/"}'>{$module.name|default:"Invalid Name"}</a></li>
										{/foreach}
									</ul>
								</li>
								{/if}
							{/foreach}
							{if isset($leftnav.Uncategorized)}
								{foreach $leftnav.Uncategorized as $moduleName => $module}
									<li><a href='{$modules.url}'>{$modules.name}</a></li>
								{/foreach}
							{/if}
								<li><a href='/module/'>Administration</a></li>
								<li><a href='/logentries/'>Log</a></li>
							</ul>
						</li>
					</ul>
				</div>
				
			</div>
			
			
			<div id="content">{block name=content}{/block}</div>
			<div class="clear"><!-- Clearing Floats --></div>
		</div>
			
		<div id="footer" class="footer">
			<div class='column first'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/globe-medium-green.png");'><a >Gateways</a></li>
					<li><a href='http://www.uaa.alaska.edu/students/'>Current Students</a></li>
					<li><a href='http://www.uaa.alaska.edu/futurestudents/'>Future Students</a></li>
					<li><a href='http://www.uaa.alaska.edu/faculty/'>Faculty</a></li>
					<li><a href='http://www.uaa.alaska.edu/staff/'>Staff</a></li>
					<li><a href='http://www.uaa.alaska.edu/alumni/'>Alumni</a></li>
					<li><br/></li>
					<li><a href='http://www.uaa.alaska.edu/classes/'>Blackboard</a></li>
					<li><a href='http://www.uaa.alaska.edu/calendar/'>Calendar</a></li>
					<li><a href='http://www.uaa.alaska.edu/emergency/'>Emergency Information</a></li>
					<li><a href='https://webaccess.uaa.alaska.edu/'>Faculty/Staff Email</a></li>
					<li><a href='http://www.uaa.alaska.edu/financialaid/'>Financial Aid</a></li>
					<li><a href='http://www.uaa.alaska.edu/parents/'>Parents</a></li>
					<li><a href='http://webmail.uaa.alaska.edu/'>Student Email</a></li>
					<li><a href='http://uaonline.alaska.edu/'>UA Online</a></li>
				</ul>
			</div>
			
			<div class='column'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/question-white.png");'><a href='http://www.uaa.alaska.edu/aboutuaa/'>About UAA</a></li>
					<li><a href='http://www.uaa.alaska.edu/accessibility/'>Accessibility</a></li>
					<li><a href='http://www.uaa.alaska.edu/administration/'>Administration</a></li>
					<li><a href='http://www.uaa.alaska.edu/chancellor/'>Chancellor's Office</a></li>
					<li><a href='http://www.uaa.alaska.edu/campuses/'>Community Campuses</a></li>
					<li><a href='http://www.uaa.alaska.edu/diversity/diversity/choices.cfm'>Diversity Resources</a></li>
					<li><a href='http://www.uaa.alaska.edu/humanresources/employment/'>Employment</a></li>
					<li><a href='http://www.uaa.alaska.edu/map'>Map</a></li>
					<li><a href='http://www.uaa.alaska.edu/chancellor/uaa-mission-statement.cfm'>Mission</a></li>
					<li><a href='http://www.uaa.alaska.edu/news/'>News and Publications</a></li>
					<li><a href='http://www.uaa.alaska.edu/strategicplan/'>Strategic Plan</a></li>
				</ul>
			</div>
			
			<div class='column'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/books.png");'><a href='http://www.uaa.alaska.edu/academics/'>Academics</a></li>
					<li><a href='http://www.uaa.alaska.edu/records/calendar.cfm'>Academic Calendar</a></li>
					<li><a href='http://www.uaa.alaska.edu/admissions/'>Admissions</a></li>
					<li><a href='http://www.uaa.alaska.edu/advising-testing/'>Advising and Testing</a></li>  
					<li><a href='http://www.uaa.alaska.edu/records/catalogs/catalogs.cfm'>Catalog</a></li>
					<li><a href='http://www.uaa.alaska.edu/records/catalogs/schedules.cfm'>Class Schedule</a></li>
					<li><a href='http://www.uaa.alaska.edu/academics/colleges.cfm'>Colleges and Schools</a></li>
					<li><a href='http://www.uaa.alaska.edu/computerlabs/'>Computer Labs</a></li>					
					<li><a href='http://lib.uaa.alaska.edu/'>Consortium Library</a></li>
					<li><a href='http://www.uaa.alaska.edu/distanceeducation/'>Distance Education</a></li>
					<li><a href='http://www.uaa.alaska.edu/financialaid/'>Financial Aid</a></li>
					<li><a href='http://www.uaa.alaska.edu/onestop/'>One Stop</a></li>
					<li><a href='http://www.uaa.alaska.edu/records/'>Registration/Registrar</a></li>
				</ul>
			</div>
			
			<div class='column'>

				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/flask--pencil.png");'><a href='http://www.uaa.alaska.edu/research/'>Research</a></li>
					<li><a href='http://www.uaa.alaska.edu/academics/research/'>Centers and Institutes</a></li>
					<li><a href='http://www.uaa.alaska.edu/academics/colleges.cfm'>Schools and Colleges</a></li>
					<li><a href='http://www.uaa.alaska.edu/ours/'>Undergraduate Research</a></li>
				</ul>
			</div>

			
			<div class='column'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/cup.png");'><a >Campus Life</a></li>
					<li><a href='http://www.uaa.alaska.edu/athletics/'>Athletics</a></li>
					<li><a href='http://www.uaa.alaska.edu/calendar/'>Calendar</a></li>
					<li><a href='http://www.uaa.alaska.edu/bookstore/'>Bookstore</a></li>
					<li><a href='http://www.uaa.alaska.edu/studentunionandcommuterstudentservices/commuterstudentservices/'>Commuter Student Services</a></li>
					<li><a href='http://www.uaa.alaska.edu/recreation/intramurals/'>Intramural Sports</a></li>
					<li><a href='http://www.uaa.alaska.edu/nss/'>Native Student Services</a></li>
					<li><a href='http://www.uaa.alaska.edu/parking/'>Parking Services</a></li>
					<li><a href='http://www.uaa.alaska.edu/residencelife/'>Residence Life</a></li>
					<li><a href='http://www.uaa.alaska.edu/studentlife/'>Student Life</a></li>
					<li><a href='http://www.uaa.alaska.edu/sll/media/'>Student Media</a></li>
					<li><a href='http://www.uaa.alaska.edu/unionofstudents/'>USUAA Student Government</a></li>	
					<li><a href='http://www.uaa.alaska.edu/recreation/sports-complex/'>Wells Fargo Sports Complex</a></li>
				</ul>
			</div>
			
			<div class='column'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/balloon-quotation.png");'><a >Public Square</a></li>
					<li><a href='http://www.uaa.alaska.edu/athletics/'>Athletics</a></li>
					<li><a href='http://www.uaa.alaska.edu/calendar/'>Calendar</a></li>
					<li><a href='http://lib.uaa.alaska.edu/'>Consortium Library</a></li>
					<li><a href='http://www.uaa.alaska.edu/giving/'>Giving to UAA</a></li>
					<li><a href='http://www.uaa.alaska.edu/news/'>News and Publications</a></li>
					<li><a href='http://greenandgold.uaa.alaska.edu/podcasts'>Podcasts</a></li>
					<li><a href='http://www.uaa.alaska.edu/visiting/'>Visiting the Campus</a></li>
					<li><a href='http://www.uaa.alaska.edu/recreation/sports-complex/'>Wells Fargo Sports Complex</a></li>
					<li><a href='http://www.uaa.alaska.edu/wwa/'>Wendy Williamson Auditorium</a></li>
				</ul>
				
			</div>
			
			<div class='column last'>
				<ul>
					<li class="header" style='list-style-image: url("/images/fugue_icons/icons/computer.png");'><a href='http://www.uaa.alaska.edu/informationtechnologyservices/'>IT Services</a></li>

					<li><a href='https://callcenter.uaa.alaska.edu'>Call Center</a></li>
					<li><a href='http://kb.uaa.alaska.edu'>Knowledge Base</a></li>
					<li><a href='https://anc-its.uaa.alaska.edu/'>Sharepoint</a></li>
					<li><a href='http://www.uaa.alaska.edu/webpublishing/'>Web Publishing</a></li>
				</ul>
			</div>
			
			<div id="footerinfo">
				<div id="bottomnav">
					<div><a href='http://www.uaa.alaska.edu/aboutuaa/index.cfm'>About UAA</a>  |  <a href='http://www.uaa.alaska.edu/contact.cfm'>Contact UAA</a>  |  <a href='http://www.alaska.edu/'>University of Alaska System</a>  | <a href='http://www.uaa.alaska.edu/policy/index.cfm'>Use Policy</a></div>
					<div><a href="mailto:web_team@uaa.alaska.edu"><img src='/images/silk_icons/comment.png' alt='' style='vertical-align: middle;' /> Provide Website Feedback</a></div>
					<div>
						<img src="/images/silk_icons/xhtml_valid.png" alt="Valid XHTML" style='vertical-align: middle;' />
						<a href="/module/" id='footerlogin'><img src="/images/ttt.gif" width="26" height="5" alt="Login" /></a>
					</div>
				</div>
				<a href="http://www.uaa.alaska.edu">&copy; Copyright 2010, University of Alaska Anchorage</a>
				<div>UAA is an EEO/AA employer and educational institution</div>
				<div>Version: {$smarty.const.VERSION}, {$smarty.const.REVISION}</div>
			</div>
		</div>
	</div>
	
	{block name=analytics}{/block}
</body>
</html>