<div id='federated'>
	<h4 class='clear'><img src='/images/federatedLogo.png' class='logo' alt='UA Logo' /> Federated Identity Resource</h4>
	
	{if !isset($User) || $User == false}
	<strong>Account could not be found.</strong>
	{else}

	<fieldset>
		<legend>Identity</legend>
		
		<div class='formEntry'>
			<label class='formLabel'>Display Name:</label>
			<div class='formData'>
				{foreach $User.displayName as $fullname}
					{$fullname}<br/>
				{foreachelse}<em>No Full Name</em>
				{/foreach}
			</div>
		</div>
		
		<div class='formEntry'>
			<label class='formLabel'>DN: </label>
			<div class='formData'>
				{foreach $User.dn as $dn}
					{$dn}<br/>
				{foreachelse}<em>Not Set</em>
				{/foreach}
			</div>
		</div>
		
		<div class='formEntry'>
			<label class='formLabel'>UA ID:</label>
			<div class='formData'>
				{foreach $User.uaIdentifier as $uniqueidentifier}
					{$uniqueidentifier}<br/>
				{foreachelse}<em>No UA ID</em>
				{/foreach}
			</div>
		</div>

		
		<div class='formEntry'>
			<label class='formLabel'>Username:</label>
			<div class='formData'>
				{foreach $User.name as $uid}
					<a href='/user/info/{$uid}'>{$uid}</a><br/>
				{foreachelse}<em>No Username</em>
				{/foreach}
			</div>
		</div>
		
		<div class='formEntry'>
			<label class='formLabel'>Identity Expiration:</label>
			<div class='formData'>
				{foreach $User.accountExpires as $expiry}
					{$expiry} <a href='/user/addDaysToExpiration'>Extend Expiration</a><br/>
				{foreachelse}<em>No Expiration Date</em>
				{/foreach}
			</div>
		</div>
		
	</fieldset>
	
	{if isset($User.uaRoleExpiration)}
	<fieldset>
		<legend>Roles</legend>
		
		{foreach $User.uaRoleExpiration as $role}
		<div class='formEntry'>
			<label class='formLabel'>{$role.name} Expiration:</label>
			<div class='formData'>
				{foreach $role.expiry as $expiry}
					{$expiry}<br/>
				{foreachelse}<em>No Expiration Date</em>
				{/foreach}
			</div>
		</div>
		{/foreach}
	</fieldset>
	{/if}
	
	{/if}
</div>