{extends file="base.tpl"}

{block name=splash}
<!--<img src='/images/administration.jpg' />-->
{/block}

{block name=content}
	<h2>Log Entries</h2>

	{$pagination|default:""}
	<table class='striped' style='width: 100%'>
		<thead>
			<tr>
				<th>Time</th>
				<th>Module</th>
				<th>User</th>
				<th>Action</th>
				<th>Entry</th>
			</tr>
		</thead>
		<tbody>
		{foreach $logEntries as $entry}
			<tr {if $entry->level == 'ERROR'} class='errorColor'{/if}>
				<td style='white-space: nowrap;'>{$entry->timestamp|date_format:"%m-%d-%Y %I:%M %p"}</td>
				<td>{$entry->module}</td>
				<td><a href='/user/info/{$entry->user}'>{$entry->user}</a></td>
				<td>{$entry->action}</td>
				<td>{$entry->entry}</td>
			</tr>
		{/foreach}
		</tbody>
	</table>
	{$pagination|default:""}
				
{/block}