{extends file="base.tpl"}

{block name=splash}
<!--<img src='/images/administration.jpg' />-->
{/block}

{block name=content}
	<h2>Modules</h2>
	
	{foreach $moduleList as $category => $modules}
	<h3>{$category}</h3>
	<table class='striped' style='width: 100%'>
		<thead>
			<tr>
				<th></th>
				<th>Name</th>
				<th>Version</th>
				<th>Left Nav</th>
				<th>User Button</th>
				<th>User Attribute</th>
				<th>Class Button</th>
				<th>Class Attribute</th>
			</tr>
		</thead>
		<tbody>
		{foreach $modules as $moduleName => $module}
			<tr>
				<td class='centered'><div class='checkbox {if $module->enabled}checked{/if}'></div></td>
				<td style='white-space: nowrap; min-width: 150px;'>{$module->name}</td>
				<td>{$module->version}</td>
				<td class='centered'><div class='checkbox {if $module->leftnav}checked{/if}'></div></td>
				<td class='centered'><div class='checkbox {if count($module->userButtons) > 0}checked{/if}'></div></td>
				<td class='centered'><div class='checkbox {if count($module->userAttributes) > 0}checked{/if}'></div></td>
				<td class='centered'><div class='checkbox {if count($module->classButtons) > 0}checked{/if}'></div></td>
				<td class='centered'><div class='checkbox {if count($module->classAttributes) > 0}checked{/if}'></div></td>
			</tr>
			<tr style=''>
				<td colspan=9 style='padding-bottom: 20px'>
					<p>{$module->description}</p>
					<div>
						<a class='button' href='/logentries/module/{$moduleName}/'>View Log Entries</a>
					</div>
				</td>
			</tr>
		{/foreach}
		</tbody>
	</table>
	{/foreach}
				
{/block}