<?php

class Aliases extends ModuleClass {

	function index() {
		$activeObject = $this->activeObject(ActiveObject::USER);
		
		$alternate = $this->sunone()->get($activeObject, array('sn', 'mailalternateaddress'));
		
		if(isset($alternate['mailalternateaddress'])) $alternate = $alternate['mailalternateaddress'];
		else $alternate = array();
		
		sort($alternate);
		
		$this->render('aliases.tpl', array('mailalternateaddress' => $alternate));
	}
	
	function newAlias() {
		try {
			//Validate the new alias
			if(!isset($_REQUEST['newAlias']) || !preg_match('/[a-zA-Z0-9._%+-]+/', $_REQUEST['newAlias'])) throw new Exception('Invalid e-mail for alias.');
			
			//Add uaa's e-mail string to the end
			$alias = $_REQUEST['newAlias'] . '@uaa.alaska.edu';
			
			$ao = $this->activeObject(ActiveObject::USER);
			$user = $this->sunone()->get($ao, array("mailalternateaddress","mail"));
			
			//Validate account and new alias against LDAP
			if(!$user)
				throw new Exception('User account could not be located.');
			elseif(isset($user['mailalternateaddress']) && (in_array($alias, $user['mailalternateaddress']) || in_array($alias, $user['mailalternateaddress'])))
				throw new Exception('This alias has already been set for the account.');
			else {
				$filter = "(|(mailalternateaddress=SearchString)(mail=SearchString))";
				$users = $this->sunone()->search($filter, $alias);
				
				if($users['count'] > 0) throw new Exception('Alias already reserved by another account.');
			}
		
			//Perform add and verify address has been added
			if($user) $sunResult = $this->sunone()->add($user['dn'], array('mailalternateaddress' => $alias));
			
			$this->log('Add Alias', $ao->uid . ' - ' . $_REQUEST['newAlias']);
			redirect('/module/load/' . get_class());
		}
		catch(Exception $e) {
			$this->error('Add Alias', $e->getMessage());
			return $this->renderError(null, "/module/load/" . get_class(), $e);
		}
	}
	
	function removeAlias($params) {
		try {
			$alias = $params[0];
			
			$ao = $this->activeObject(ActiveObject::USER);
			$user = $this->sunone()->get($ao, array());

			//Validate account
			if(!$user) throw new Exception('User account could not be located in SunOne.');
		
			//Perform remove
			if($user) $sunResult = $this->sunone()->remove($user['dn'], array('mailalternateaddress' => $alias . '@uaa.alaska.edu'));
			
			$this->log('Remove Alias', $ao->uid . ' - ' . $alias);
			redirect('/module/load/' . get_class());
		}
		catch(Exception $e) {
			$this->error('Remove Alias', $e->getMessage());
			return $this->renderError(null, "/module/load/" . get_class(), $e);
		}
	}
	
}


?>