<?php

class BlackboardEnrollment extends ModuleClass {

	function index() {
		$ao = $this->activeObject(ActiveObject::COURSE);
		
		$params = array();
		$params['enrollment'] = $this->blackboard()->getEnrollment($ao);
	
		$this->render('enrollment.tpl', $params);
	}
	
	function activate($user_pk1) {
		$ao = $this->activeObject(ActiveObject::COURSE);
		$user_pk1 = $user_pk1[0];
		
		if($this->blackboard()->activateUserForCourse($ao, $user_pk1) != true) {
			$this->error('Activate User', "Could not activate user $user_pk1 for course <a href='$ao->url'>$ao->id</a>");
			$this->renderError("Could not activate user $user_pk1 for course <a href='$ao->url'>$ao->id</a>", '/module/load/' . get_class());
		}
		else {
			$this->log('Activate User', "Activated user $user_pk1 for course <a href='$ao->url'>$ao->id</a>");
			redirect('/module/load/' . get_class());
		}
	}
	
	function deactivate($user_pk1) {
		$ao = $this->activeObject(ActiveObject::COURSE);
		$user_pk1 = $user_pk1[0];
		
		if($this->blackboard()->deactivateUserForCourse($ao, $user_pk1) != true) {
			$this->error('Deactivate User', "Could not deactivate user $user_pk1 for course <a href='$ao->url'>$ao->id</a>");
			$this->renderError("Could not dectivate user $user_pk1 for course <a href='$ao->url'>$ao->id</a>", '/module/load/' . get_class());
		}
		else {
			$this->log('Deactivate User', "Deactivated user $user_pk1 for course <a href='$ao->url'>$ao->id</a>");
			redirect('/module/load/' . get_class());
		}
	}
}


?>