<?php

class BlackboardStatus extends ModuleClass {

	function isActive() {
		$ao = $this->activeObject(ActiveObject::COURSE);
		$obj = $this->blackboard()->get($ao);
		
		if($obj) {
			if($obj->row_status == 0) return true;
			elseif($obj->row_status == 2) return false;
			else return "Unknown row status: " . $obj->row_status;
		}
		else return "Course could not be found.";
	}
	
	function activate() {
		$ao = $this->activeObject(ActiveObject::COURSE);
		
		if($this->blackboard()->activateCourse($ao) != true) {
			$this->error('Activate Course', "Could not activate course <a href='$ao->url'>$ao->id</a>");
			$this->renderError("Could not activate course <a href='$ao->url'>$ao->id</a>", $ao->url);
		}
		else {
			$this->log('Activate Course', "Activated course <a href='/course/info/$params[0]'>$params[0]</a>");
			redirect($ao->url);
		}
	}
	
	function deactivate() {
		$ao = $this->activeObject(ActiveObject::COURSE);
		
		if($this->blackboard()->deactivateCourse($ao) != true) {
			$this->error('Deactivate Course', "Could not deactivate course <a href='$ao->url'>$ao->id</a>");
			$this->renderError("Could not deactivate course <a href='$ao->url'>$ao->id</a>", $ao->url);
		}
		else {
			$this->log('Deactivate Course', "Deactivated course <a href='$ao->url'>$ao->id</a>");
			redirect($ao->url);
		}
	}
}


?>